/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.enc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQSimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.AbstractEncapsulatorSimQueue;
import org.javades.jqueues.r5.listener.MultiSimQueueNotificationProcessor;
import org.javades.jsimulation.r5.SimEventList;

public class EncXM<DJ extends SimJob, DQ extends SimQueue, J extends SimJob, Q extends EncXM>
extends AbstractEncapsulatorSimQueue<DJ, DQ, J, Q> {
    private final MappableExitMethod dropMapping;
    private final MappableExitMethod autoRevocationMapping;
    private final MappableExitMethod departureMapping;

    public EncXM(SimEventList eventList, DQ queue, MappableExitMethod dropMapping, MappableExitMethod autoRevocationMapping, MappableExitMethod departureMapping, DelegateSimJobFactory delegateSimJobFactory) {
        super(eventList, queue, delegateSimJobFactory);
        this.dropMapping = dropMapping != null ? dropMapping : MappableExitMethod.DROP;
        this.autoRevocationMapping = autoRevocationMapping != null ? autoRevocationMapping : MappableExitMethod.AUTO_REVOCATION;
        this.departureMapping = departureMapping != null ? departureMapping : MappableExitMethod.DEPARTURE;
    }

    public EncXM<DJ, DQ, J, Q> getCopySimQueue() {
        SimQueue encapsulatedQueueCopy = this.getEncapsulatedQueue().getCopySimQueue();
        return new EncXM(this.getEventList(), encapsulatedQueueCopy, this.getDropMapping(), this.getAutoRevocationMapping(), this.getDepartureMapping(), this.getDelegateSimJobFactory());
    }

    @Override
    public String toStringDefault() {
        String mapping = "";
        boolean first = true;
        if (this.getDropMapping() != MappableExitMethod.DROP) {
            mapping = "Dr->" + (Object)((Object)this.getDropMapping());
            first = false;
        }
        if (this.getAutoRevocationMapping() != MappableExitMethod.AUTO_REVOCATION) {
            mapping = first ? mapping + "AR->" : mapping + ",AR->";
            mapping = mapping + (Object)((Object)this.getAutoRevocationMapping());
            first = false;
        }
        if (this.getDepartureMapping() != MappableExitMethod.DEPARTURE) {
            mapping = first ? mapping + "De->" : mapping + ",De->";
            mapping = mapping + (Object)((Object)this.getDepartureMapping());
        }
        return "EncXM(" + mapping + ")[" + this.getEncapsulatedQueue() + "]";
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    public final MappableExitMethod getDropMapping() {
        return this.dropMapping;
    }

    public final MappableExitMethod getAutoRevocationMapping() {
        return this.autoRevocationMapping;
    }

    public final MappableExitMethod getDepartureMapping() {
        return this.departureMapping;
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
    }

    @Override
    protected final void queueAccessVacationDropSubClass(double time, J job) {
        super.queueAccessVacationDropSubClass(time, job);
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        super.insertJobInQueueUponArrival(job, time);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        super.rescheduleAfterArrival(job, time);
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        super.removeJobFromQueueUponDrop(job, time);
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        super.rescheduleAfterDrop(job, time);
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        super.removeJobFromQueueUponRevokation(job, time, auto);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        super.rescheduleAfterRevokation(job, time, auto);
    }

    @Override
    public final boolean isStartArmed() {
        return super.isStartArmed();
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        super.rescheduleForNewServerAccessCredits(time);
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        super.insertJobInQueueUponStart(job, time);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        super.rescheduleAfterStart(job, time);
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        super.removeJobFromQueueUponDeparture(departingJob, time);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        super.rescheduleAfterDeparture(departedJob, time);
    }

    @Override
    protected final void processSubQueueNotifications(List<MultiSimQueueNotificationProcessor.Notification<DJ, DQ>> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            super.processSubQueueNotifications(notifications);
            return;
        }
        boolean isTopLevel = this.clearAndUnlockPendingNotificationsIfLocked();
        SimQueue encQueue = this.getEncapsulatedQueue();
        for (MultiSimQueueNotificationProcessor.Notification<DJ, DQ> notification : notifications) {
            if (notification.getTime() != this.getLastUpdateTime()) {
                throw new IllegalStateException();
            }
            if (notification.getQueue() != this.getEncapsulatedQueue()) {
                throw new IllegalStateException();
            }
            List<Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>>> subNotifications = notification.getSubNotifications();
            block13: for (int i = 0; i < subNotifications.size(); ++i) {
                DJ job;
                Map<SimEntitySimpleEventType.Member, SimJQEvent<DJ, DQ>> subNotification = subNotifications.get(i);
                if (subNotification.size() != 1) {
                    throw new IllegalArgumentException();
                }
                if (this.getDropMapping() != MappableExitMethod.DROP && subNotification.containsKey(SimJQSimpleEventType.DROP)) {
                    if (subNotification.get(SimJQSimpleEventType.DROP).getTime() != this.getLastUpdateTime()) {
                        throw new IllegalArgumentException();
                    }
                    job = subNotification.get(SimJQSimpleEventType.DROP).getJob();
                    switch (this.getDropMapping()) {
                        case AUTO_REVOCATION: {
                            subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.AUTO_REVOCATION, new SimJQEvent.AutoRevocation(job, encQueue, notification.getTime())));
                            break;
                        }
                        case DEPARTURE: {
                            subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.DEPARTURE, new SimJQEvent.Departure(job, encQueue, notification.getTime())));
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    continue;
                }
                if (this.getAutoRevocationMapping() != MappableExitMethod.AUTO_REVOCATION && subNotification.containsKey(SimJQSimpleEventType.AUTO_REVOCATION)) {
                    if (subNotification.get(SimJQSimpleEventType.AUTO_REVOCATION).getTime() != this.getLastUpdateTime()) {
                        throw new IllegalArgumentException();
                    }
                    job = subNotification.get(SimJQSimpleEventType.AUTO_REVOCATION).getJob();
                    switch (this.getAutoRevocationMapping()) {
                        case DROP: {
                            subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.DROP, new SimJQEvent.Drop(job, encQueue, notification.getTime())));
                            break;
                        }
                        case DEPARTURE: {
                            subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.DEPARTURE, new SimJQEvent.Departure(job, encQueue, notification.getTime())));
                            break;
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                    continue;
                }
                if (this.getDepartureMapping() == MappableExitMethod.DEPARTURE || !subNotification.containsKey(SimJQSimpleEventType.DEPARTURE)) continue;
                if (subNotification.get(SimJQSimpleEventType.DEPARTURE).getTime() != this.getLastUpdateTime()) {
                    throw new IllegalArgumentException();
                }
                job = subNotification.get(SimJQSimpleEventType.DEPARTURE).getJob();
                switch (this.getDepartureMapping()) {
                    case DROP: {
                        subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.DROP, new SimJQEvent.Drop(job, encQueue, notification.getTime())));
                        continue block13;
                    }
                    case AUTO_REVOCATION: {
                        subNotifications.set(i, Collections.singletonMap(SimJQSimpleEventType.AUTO_REVOCATION, new SimJQEvent.AutoRevocation(job, encQueue, notification.getTime())));
                        continue block13;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
            }
        }
        super.processSubQueueNotifications(notifications);
        if (isTopLevel) {
            this.fireAndLockPendingNotifications();
        }
    }

    public static enum MappableExitMethod {
        DROP("Dr"),
        AUTO_REVOCATION("AR"),
        DEPARTURE("De");

        private final String name;

        private MappableExitMethod(String name) {
            this.name = name;
        }

        public final String toString() {
            return this.name;
        }
    }
}

