/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.feedback;

import java.util.HashMap;
import java.util.Map;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.entity.jq.queue.composite.feedback.SimQueueFeedbackController;

public class FeedbackSimQueueSelector<J extends SimJob, DQ extends SimQueue>
implements SimQueueSelector<J, DQ> {
    private final DQ queue;
    private final SimQueueFeedbackController<J, DQ> feedbackController;
    private final Map<J, Integer> visits = new HashMap<J, Integer>();

    public FeedbackSimQueueSelector(DQ queue, SimQueueFeedbackController<J, DQ> feedbackController) {
        if (queue == null || feedbackController == null) {
            throw new IllegalArgumentException();
        }
        this.queue = queue;
        this.feedbackController = feedbackController;
    }

    public final SimQueueFeedbackController<J, DQ> getFeedbackController() {
        return this.feedbackController;
    }

    @Override
    public void resetSimQueueSelector() {
        this.feedbackController.resetFeedbackController();
        this.visits.clear();
    }

    @Override
    public DQ selectFirstQueue(double time, J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (this.visits.containsKey(job)) {
            throw new IllegalStateException();
        }
        this.visits.put(job, 0);
        return this.queue;
    }

    @Override
    public DQ selectNextQueue(double time, J job, DQ previousQueue) {
        if (previousQueue != this.queue) {
            throw new IllegalStateException();
        }
        if (!this.visits.containsKey(job) || this.visits.get(job) == null) {
            throw new IllegalStateException();
        }
        this.visits.put(job, this.visits.get(job) + 1);
        if (this.feedbackController.feedback(time, previousQueue, job, this.visits.get(job))) {
            return previousQueue;
        }
        this.visits.remove(job);
        return null;
    }
}

