/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.jackson;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;

public class JacksonSimQueueSelector<J extends SimJob, DQ extends SimQueue>
implements SimQueueSelector<J, DQ> {
    private final Set<DQ> queues;
    private final double[] pdfArrival;
    private final double[] cdfArrival;
    private final double[][] pdfTransition;
    private final double[][] cdfTransition;
    private final Random rng;

    public JacksonSimQueueSelector(Set<DQ> queues, double[] pdfArrival, double[][] pdfTransition, Random userRNG) {
        int r;
        if (queues == null || queues.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.queues = new LinkedHashSet<DQ>(queues);
        JacksonSimQueueSelector.checkPdfArray(pdfArrival, queues.size());
        this.pdfArrival = Arrays.copyOf(pdfArrival, pdfArrival.length);
        this.cdfArrival = new double[queues.size()];
        for (int e = 0; e < queues.size(); ++e) {
            this.cdfArrival[e] = this.pdfArrival[e] + (e > 0 ? this.cdfArrival[e - 1] : 0.0);
        }
        JacksonSimQueueSelector.checkPdfMatrix(pdfTransition, queues.size());
        this.pdfTransition = new double[queues.size()][];
        for (r = 0; r < queues.size(); ++r) {
            this.pdfTransition[r] = Arrays.copyOf(pdfTransition[r], queues.size());
        }
        this.cdfTransition = new double[queues.size()][queues.size()];
        for (r = 0; r < queues.size(); ++r) {
            for (int c = 0; c < queues.size(); ++c) {
                this.cdfTransition[r][c] = this.pdfTransition[r][c] + (c > 0 ? this.cdfTransition[r][c - 1] : 0.0);
            }
        }
        this.rng = userRNG != null ? userRNG : new Random();
    }

    protected static void checkPdfArray(double[] pdfArray, int requiredSize) {
        if (pdfArray == null || pdfArray.length != requiredSize) {
            throw new IllegalArgumentException();
        }
        int pArraySum = 0;
        for (double p : pdfArray) {
            if (p < 0.0 || p > 1.0) {
                throw new IllegalArgumentException();
            }
            pArraySum = (int)((double)pArraySum + p);
        }
        if (pArraySum > 1) {
            throw new IllegalArgumentException();
        }
    }

    protected static void checkPdfMatrix(double[][] pdfMatrix, int requiredSize) {
        if (pdfMatrix == null || pdfMatrix.length != requiredSize) {
            throw new IllegalArgumentException();
        }
        for (double[] p_row : pdfMatrix) {
            JacksonSimQueueSelector.checkPdfArray(p_row, requiredSize);
        }
    }

    public final double[] getPdfArrival() {
        return this.pdfArrival;
    }

    public final double[][] getPdfTransition() {
        return this.pdfTransition;
    }

    public final Random getRNG() {
        return this.rng;
    }

    private DQ draw(double[] cdfArray) {
        if (cdfArray == null || cdfArray.length != this.queues.size()) {
            throw new IllegalArgumentException();
        }
        double sample = this.rng.nextDouble();
        if (sample < 0.0 || sample >= 1.0) {
            throw new RuntimeException();
        }
        for (int q = 0; q < this.queues.size(); ++q) {
            if (!(sample < cdfArray[q])) continue;
            return AbstractSimQueueComposite.getQueue(this.queues, q);
        }
        return null;
    }

    @Override
    public void resetSimQueueSelector() {
    }

    @Override
    public DQ selectFirstQueue(double time, J job) {
        return this.draw(this.cdfArrival);
    }

    @Override
    public DQ selectNextQueue(double time, J job, DQ previousQueue) {
        return this.draw(this.cdfTransition[AbstractSimQueueComposite.getIndex(this.queues, previousQueue)]);
    }
}

