/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.parallel;

import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.entity.jq.queue.composite.parallel.AbstractParallelSimQueues;
import org.javades.jsimulation.r5.SimEventList;

public class JSQ<DJ extends AbstractSimJob, DQ extends SimQueue, J extends SimJob, Q extends JSQ>
extends AbstractParallelSimQueues<DJ, DQ, J, Q> {
    private final boolean onlyWaitingJobs;

    private static SimQueueSelector createSimQueueSelector(final Set<SimQueue> queues, final boolean onlyWaitingJobs, final Random rng) {
        if (queues == null || queues.contains(null) || rng == null) {
            throw new IllegalArgumentException();
        }
        return new SimQueueSelector(){

            @Override
            public void resetSimQueueSelector() {
            }

            public final SimQueue selectFirstQueue(double time, SimJob job) {
                if (job == null) {
                    throw new IllegalArgumentException();
                }
                Set shortestQueues = JSQ.selectShortestQueues(queues, onlyWaitingJobs);
                return JSQ.getRandomSimQueueFromSet(shortestQueues, rng);
            }

            public final SimQueue selectNextQueue(double time, SimJob job, SimQueue previousQueue) {
                if (job == null || previousQueue == null || !queues.contains(previousQueue)) {
                    throw new IllegalArgumentException();
                }
                return null;
            }
        };
    }

    public JSQ(SimEventList eventList, Set<DQ> queues, DelegateSimJobFactory delegateSimJobFactory, boolean onlyWaitingJobs, Random rng) {
        super(eventList, queues, JSQ.createSimQueueSelector(queues, onlyWaitingJobs, rng != null ? rng : new Random()), delegateSimJobFactory);
        this.onlyWaitingJobs = onlyWaitingJobs;
    }

    public JSQ<DJ, DQ, J, Q> getCopySimQueue() {
        Set queuesCopy = this.getCopySubSimQueues();
        return new JSQ(this.getEventList(), queuesCopy, this.getDelegateSimJobFactory(), this.isOnlyWaitingJobs(), null);
    }

    @Override
    public String toStringDefault() {
        String string = "JSQ[";
        boolean first = true;
        for (SimQueue dq : this.getQueues()) {
            if (!first) {
                string = string + ",";
            } else {
                first = false;
            }
            string = string + dq;
        }
        string = string + "]";
        return string;
    }

    public final boolean isOnlyWaitingJobs() {
        return this.onlyWaitingJobs;
    }

    private static Set<SimQueue> selectShortestQueues(Set<SimQueue> queues, boolean onlyWaitingJobs) {
        if (queues == null || queues.contains(null)) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<SimQueue> set = new LinkedHashSet<SimQueue>();
        int currentNrOfJobs = 0;
        for (SimQueue q : queues) {
            int nrOfJobs;
            int n = nrOfJobs = onlyWaitingJobs ? q.getNumberOfJobs() - q.getNumberOfJobsInServiceArea() : q.getNumberOfJobs();
            if (set.isEmpty()) {
                set.add(q);
                currentNrOfJobs = nrOfJobs;
                continue;
            }
            if (nrOfJobs < currentNrOfJobs) {
                set.clear();
                set.add(q);
                currentNrOfJobs = nrOfJobs;
                continue;
            }
            if (nrOfJobs != currentNrOfJobs) continue;
            set.add(q);
        }
        return set;
    }

    public static SimQueue getRandomSimQueueFromSet(Set<SimQueue> queues, Random rng) {
        if (queues == null || queues.contains(null) || rng == null) {
            throw new IllegalArgumentException();
        }
        if (queues.isEmpty()) {
            return null;
        }
        if (queues.size() == 1) {
            return queues.iterator().next();
        }
        int draw = rng.nextInt(queues.size());
        int i_q = 0;
        for (SimQueue q : queues) {
            if (i_q == draw) {
                return q;
            }
            ++i_q;
        }
        throw new RuntimeException();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
    }
}

