/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.composite.parallel;

import java.util.Arrays;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.entity.jq.queue.composite.parallel.AbstractParallelSimQueues;
import org.javades.jsimulation.r5.SimEventList;

public class Pattern<DJ extends AbstractSimJob, DQ extends SimQueue, J extends SimJob, Q extends Pattern>
extends AbstractParallelSimQueues<DJ, DQ, J, Q> {
    private final int[] pattern;

    private static SimQueueSelector createSimQueueSelector(final Set<SimQueue> queues, final int[] pattern) {
        if (queues == null || queues.contains(null)) {
            throw new IllegalArgumentException();
        }
        return new SimQueueSelector(){
            private int lastIndex = -1;

            @Override
            public void resetSimQueueSelector() {
                this.lastIndex = -1;
            }

            public final SimQueue selectFirstQueue(double time, SimJob job) {
                if (job == null) {
                    throw new IllegalArgumentException();
                }
                if (pattern == null || pattern.length == 0) {
                    return null;
                }
                this.lastIndex = (this.lastIndex + 1) % pattern.length;
                int queueIndex = pattern[this.lastIndex];
                if (queueIndex < 0 || queueIndex >= queues.size()) {
                    return null;
                }
                return AbstractSimQueueComposite.getQueue(queues, queueIndex);
            }

            public final SimQueue selectNextQueue(double time, SimJob job, SimQueue previousQueue) {
                if (job == null || previousQueue == null || !queues.contains(previousQueue)) {
                    throw new IllegalArgumentException();
                }
                return null;
            }
        };
    }

    public Pattern(SimEventList eventList, Set<DQ> queues, DelegateSimJobFactory delegateSimJobFactory, int[] pattern) {
        super(eventList, queues, Pattern.createSimQueueSelector(queues, pattern), delegateSimJobFactory);
        this.pattern = (int[])(pattern == null ? null : Arrays.copyOf(pattern, pattern.length));
    }

    public Pattern<DJ, DQ, J, Q> getCopySimQueue() {
        Set queuesCopy = this.getCopySubSimQueues();
        return new Pattern(this.getEventList(), queuesCopy, this.getDelegateSimJobFactory(), this.getPattern());
    }

    @Override
    public String toStringDefault() {
        boolean first;
        String string = "Pattern{";
        if (this.pattern == null) {
            string = string + "null";
        } else {
            first = true;
            for (int i : this.pattern) {
                if (!first) {
                    string = string + ",";
                } else {
                    first = false;
                }
                string = string + i;
            }
        }
        string = string + "}[";
        first = true;
        Object object = this.getQueues().iterator();
        while (object.hasNext()) {
            SimQueue dq = (SimQueue)object.next();
            if (!first) {
                string = string + ",";
            } else {
                first = false;
            }
            string = string + dq;
        }
        string = string + "]";
        return string;
    }

    public final int[] getPattern() {
        if (this.pattern == null) {
            return null;
        }
        return Arrays.copyOf(this.pattern, this.pattern.length);
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
    }
}

