/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.preemptive;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.AbstractClassicSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jqueues.r5.util.collection.HashMapWithPreImageAndOrderedValueSet;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractPreemptiveSimQueue<J extends SimJob, Q extends AbstractPreemptiveSimQueue>
extends AbstractClassicSimQueue<J, Q> {
    public static final PreemptionStrategy DEFAULT_PREEMPTION_STRATEGY = PreemptionStrategy.RESUME;
    private final PreemptionStrategy preemptionStrategy;
    public static final double TOLERANCE_RST = 1.0E-9;
    protected final HashMapWithPreImageAndOrderedValueSet<J, Double> remainingServiceTime = new HashMapWithPreImageAndOrderedValueSet();
    protected final Map<J, Double> jobsBeingServed = new HashMap<J, Double>();

    protected AbstractPreemptiveSimQueue(SimEventList eventList, int bufferSize, int numberOfServers, PreemptionStrategy preemptionStrategy) {
        super(eventList, bufferSize, numberOfServers);
        this.preemptionStrategy = preemptionStrategy == null ? DEFAULT_PREEMPTION_STRATEGY : preemptionStrategy;
        this.registerPreUpdateHook(this::updateRemainingServiceTime);
    }

    public final PreemptionStrategy getPreemptionStrategy() {
        return this.preemptionStrategy;
    }

    protected final void updateRemainingServiceTime(double newTime) {
        for (Map.Entry<J, Double> entry : this.jobsBeingServed.entrySet()) {
            SimJob job = (SimJob)entry.getKey();
            double dT = newTime - entry.getValue();
            if (dT < 0.0) {
                throw new IllegalStateException();
            }
            if (!(dT > 0.0)) continue;
            if ((Double)this.remainingServiceTime.get(job) < 0.0 || (Double)this.remainingServiceTime.get(job) < dT - 1.0E-9) {
                throw new IllegalStateException();
            }
            if ((Double)this.remainingServiceTime.get(job) < dT) {
                this.remainingServiceTime.put(job, 0.0);
            } else {
                this.remainingServiceTime.put(job, (Double)this.remainingServiceTime.get(job) - dT);
            }
            entry.setValue(newTime);
        }
    }

    public final Set<J> getJobsBeingServed() {
        return this.jobsBeingServed.keySet();
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.remainingServiceTime.clear();
        this.jobsBeingServed.clear();
    }

    @Override
    protected final void queueAccessVacationDropSubClass(double time, J job) {
        super.queueAccessVacationDropSubClass(time, job);
    }

    protected final void preemptJob(double time, J job) {
        if (job == null || !this.jobsBeingServed.keySet().contains(job)) {
            throw new IllegalArgumentException();
        }
        if (!this.remainingServiceTime.containsKey(job)) {
            throw new IllegalStateException();
        }
        switch (this.getPreemptionStrategy()) {
            case DROP: {
                this.drop(job, time);
                break;
            }
            case RESUME: {
                this.jobsBeingServed.remove(job);
                this.cancelDepartureEvent(job);
                break;
            }
            case RESTART: {
                this.jobsBeingServed.remove(job);
                this.cancelDepartureEvent(job);
                this.remainingServiceTime.put(job, this.getServiceTimeForJob(job));
                break;
            }
            case REDRAW: {
                throw new UnsupportedOperationException("PreemptionStrategy.REDRAW is not supported.");
            }
            case DEPART: {
                this.depart(time, job);
                break;
            }
            case CUSTOM: {
                throw new UnsupportedOperationException("PreemptionStrategy.CUSTOM is not supported yet.");
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    protected final void startServiceChunk(double time, J job) {
        if (job == null || this.jobsBeingServed.keySet().contains(job)) {
            throw new IllegalArgumentException();
        }
        if (!this.remainingServiceTime.containsKey(job)) {
            throw new IllegalStateException();
        }
        this.jobsBeingServed.put(job, time);
        double rs_job = (Double)this.remainingServiceTime.get(job);
        if (Double.isFinite(rs_job)) {
            if (Double.isFinite(time) && rs_job > 1.0E-9) {
                this.scheduleDepartureEvent(time + rs_job, job);
            } else {
                this.depart(time, job);
            }
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        this.removeJobFromQueueUponExit(job, time);
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        this.rescheduleAfterExit(time);
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        this.removeJobFromQueueUponExit(job, time);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        this.rescheduleAfterExit(time);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        this.removeJobFromQueueUponExit(departingJob, time);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        this.rescheduleAfterExit(time);
    }

    protected abstract void removeJobFromQueueUponExit(J var1, double var2);

    protected abstract void rescheduleAfterExit(double var1);
}

