/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.preemptive;

import java.util.ArrayList;
import java.util.List;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.AbstractPreemptiveSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jsimulation.r5.SimEventList;

public class P_LCFS<J extends SimJob, Q extends P_LCFS>
extends AbstractPreemptiveSimQueue<J, Q> {
    private final List<J> lifoJobQueue = new ArrayList<J>();
    private final List<J> lifoWaitQueue = new ArrayList<J>();

    public P_LCFS(SimEventList eventList, PreemptionStrategy preemptionStrategy) {
        super(eventList, Integer.MAX_VALUE, 1, preemptionStrategy);
    }

    @Override
    public P_LCFS<J, Q> getCopySimQueue() {
        return new P_LCFS<J, Q>(this.getEventList(), this.getPreemptionStrategy());
    }

    @Override
    public String toStringDefault() {
        return "P_LCFS[" + (Object)((Object)this.getPreemptionStrategy()) + "]";
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.lifoJobQueue.clear();
        this.lifoWaitQueue.clear();
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        this.lifoJobQueue.add(0, job);
        this.lifoWaitQueue.add(0, job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (!this.isJob((SimJob)job)) {
            throw new IllegalStateException();
        }
        if (this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalStateException();
        }
        if (this.lifoJobQueue.get(0) != job || this.lifoWaitQueue.get(0) != job) {
            throw new IllegalStateException();
        }
        if (this.hasServerAcccessCredits()) {
            this.start(time, job);
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        while (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea()) {
            this.start(time, (SimJob)this.lifoWaitQueue.get(0));
        }
    }

    @Override
    public final boolean isStartArmed() {
        return true;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job) || this.remainingServiceTime.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        if (this.lifoWaitQueue.get(0) != job) {
            throw new IllegalStateException();
        }
        this.lifoWaitQueue.remove(0);
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        this.remainingServiceTime.put(job, jobServiceTime);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        SimJob jobBeingServed;
        if (!(job != null && this.getJobs().contains(job) && this.getJobsInServiceArea().contains(job) && this.remainingServiceTime.containsKey(job))) {
            throw new IllegalArgumentException();
        }
        if (this.jobsBeingServed.containsKey(job)) {
            throw new IllegalStateException();
        }
        if (this.jobsBeingServed.size() > 1) {
            throw new IllegalStateException();
        }
        SimJob simJob = jobBeingServed = this.jobsBeingServed.isEmpty() ? null : (SimJob)this.jobsBeingServed.keySet().iterator().next();
        if (jobBeingServed == null || this.lifoJobQueue.indexOf(job) < this.lifoJobQueue.indexOf(jobBeingServed)) {
            if (jobBeingServed != null) {
                this.preemptJob(time, jobBeingServed);
            }
            if (this.jobsBeingServed.isEmpty()) {
                this.startServiceChunk(time, job);
            } else {
                if (this.jobsBeingServed.size() > 1) {
                    throw new IllegalStateException();
                }
                if (this.jobsBeingServed.keySet().iterator().next() != job) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponExit(J exitingJob, double time) {
        if (exitingJob == null || !this.isJob((SimJob)exitingJob)) {
            throw new IllegalArgumentException();
        }
        if (!this.lifoJobQueue.remove(exitingJob)) {
            throw new IllegalStateException();
        }
        if (this.isJobInServiceArea((SimJob)exitingJob)) {
            if (!this.remainingServiceTime.containsKey(exitingJob)) {
                throw new IllegalStateException();
            }
            this.remainingServiceTime.remove(exitingJob);
            if (this.jobsBeingServed.containsKey(exitingJob)) {
                if (!this.getDepartureEvents(exitingJob).isEmpty()) {
                    if (this.getDepartureEvents(exitingJob).size() > 1) {
                        throw new IllegalStateException();
                    }
                    this.cancelDepartureEvent(exitingJob);
                }
                this.jobsBeingServed.remove(exitingJob);
            }
        } else if (!this.lifoWaitQueue.remove(exitingJob)) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected final void rescheduleAfterExit(double time) {
        if (this.jobsBeingServed.isEmpty() && this.hasJobsInServiceArea()) {
            SimJob jobToStartServiceChunk = null;
            for (SimJob j : this.lifoJobQueue) {
                if (!this.isJobInServiceArea(j)) continue;
                jobToStartServiceChunk = j;
                break;
            }
            if (jobToStartServiceChunk == null) {
                throw new IllegalStateException();
            }
            this.startServiceChunk(time, jobToStartServiceChunk);
        }
    }
}

