/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.preemptive;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.AbstractPreemptiveSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jsimulation.r5.SimEventList;

public class SRTF<J extends SimJob, Q extends SRTF>
extends AbstractPreemptiveSimQueue<J, Q> {
    private final List<J> srtfWaitingQueue = new ArrayList<J>();

    public SRTF(SimEventList eventList, PreemptionStrategy preemptionStrategy) {
        super(eventList, Integer.MAX_VALUE, 1, preemptionStrategy);
    }

    @Override
    public SRTF<J, Q> getCopySimQueue() {
        return new SRTF<J, Q>(this.getEventList(), this.getPreemptionStrategy());
    }

    @Override
    public String toStringDefault() {
        return "SRTF[" + (Object)((Object)this.getPreemptionStrategy()) + "]";
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.srtfWaitingQueue.clear();
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        int newPosition;
        for (newPosition = 0; newPosition < this.srtfWaitingQueue.size() && this.getServiceTimeForJob((SimJob)this.srtfWaitingQueue.get(newPosition)) <= this.getServiceTimeForJob(job); ++newPosition) {
        }
        this.srtfWaitingQueue.add(newPosition, job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (job == null || !this.isJobInWaitingArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        if (this.hasServerAcccessCredits()) {
            this.start(time, job);
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        while (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea()) {
            this.start(time, (SimJob)this.srtfWaitingQueue.get(0));
        }
    }

    @Override
    public final boolean isStartArmed() {
        return true;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.getJobs().contains(job) || this.getJobsInServiceArea().contains(job) || this.remainingServiceTime.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        if (this.srtfWaitingQueue.get(0) != job) {
            throw new IllegalStateException();
        }
        this.srtfWaitingQueue.remove(0);
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        this.remainingServiceTime.put(job, jobServiceTime);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        SimJob jobBeingServed;
        if (!(job != null && this.getJobs().contains(job) && this.getJobsInServiceArea().contains(job) && this.remainingServiceTime.containsKey(job))) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = (Double)this.remainingServiceTime.get(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        if (!this.jobsBeingServed.isEmpty()) {
            if (this.jobsBeingServed.size() > 1) {
                throw new IllegalStateException();
            }
            jobBeingServed = (SimJob)this.jobsBeingServed.keySet().iterator().next();
        } else {
            jobBeingServed = null;
        }
        if (job == jobBeingServed) {
            throw new IllegalStateException();
        }
        if (jobBeingServed == null || jobServiceTime < (Double)this.remainingServiceTime.get(jobBeingServed)) {
            if (jobBeingServed != null) {
                this.preemptJob(time, jobBeingServed);
            }
            if (this.jobsBeingServed.isEmpty()) {
                this.startServiceChunk(time, job);
            } else {
                if (this.jobsBeingServed.size() > 1) {
                    throw new IllegalStateException();
                }
                if (this.jobsBeingServed.keySet().iterator().next() != job) {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponExit(J exitingJob, double time) {
        if (exitingJob == null || !this.isJob((SimJob)exitingJob)) {
            throw new IllegalArgumentException();
        }
        if (this.isJobInServiceArea((SimJob)exitingJob)) {
            if (this.srtfWaitingQueue.contains(exitingJob)) {
                throw new IllegalStateException();
            }
            if (!this.remainingServiceTime.containsKey(exitingJob)) {
                throw new IllegalStateException();
            }
            this.remainingServiceTime.remove(exitingJob);
            if (this.jobsBeingServed.containsKey(exitingJob)) {
                if (!this.getDepartureEvents(exitingJob).isEmpty()) {
                    if (this.getDepartureEvents(exitingJob).size() > 1) {
                        throw new IllegalStateException();
                    }
                    this.cancelDepartureEvent(exitingJob);
                }
                this.jobsBeingServed.remove(exitingJob);
            }
        } else if (!this.srtfWaitingQueue.remove(exitingJob)) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected final void rescheduleAfterExit(double time) {
        if (this.jobsBeingServed.isEmpty() && this.hasJobsInServiceArea()) {
            double sRST = (Double)this.remainingServiceTime.firstValue();
            Set jobsWithSRST = this.remainingServiceTime.getPreImageForValue(sRST);
            if (jobsWithSRST.isEmpty()) {
                throw new IllegalStateException();
            }
            this.startServiceChunk(time, (SimJob)jobsWithSRST.iterator().next());
        }
    }
}

