/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.processorsharing;

import java.util.Set;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.AbstractProcessorSharingSimQueue;
import org.javades.jqueues.r5.util.collection.HashMapWithPreImageAndOrderedValueSet;
import org.javades.jsimulation.r5.SimEventList;

public abstract class AbstractEgalitarianProcessorSharingSimQueue<J extends SimJob, Q extends AbstractEgalitarianProcessorSharingSimQueue>
extends AbstractProcessorSharingSimQueue<J, Q>
implements SimQueue<J, Q> {
    private double virtualTime = 0.0;
    protected final HashMapWithPreImageAndOrderedValueSet<J, Double> virtualDepartureTime = new HashMapWithPreImageAndOrderedValueSet();

    protected AbstractEgalitarianProcessorSharingSimQueue(SimEventList eventList, int bufferSize, int numberOfServers) {
        super(eventList, bufferSize, numberOfServers);
        this.registerPreUpdateHook(this::updateVirtualTime);
    }

    protected final double getVirtualTime() {
        return this.virtualTime;
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.virtualTime = 0.0;
        this.virtualDepartureTime.clear();
    }

    protected final void updateVirtualTime(double newTime) {
        if (newTime < this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        int numberOfJobsExecuting = this.getNumberOfJobsInServiceArea();
        if (numberOfJobsExecuting == 0) {
            this.virtualTime = 0.0;
        } else if (newTime > this.getLastUpdateTime()) {
            this.virtualTime += (newTime - this.getLastUpdateTime()) / (double)numberOfJobsExecuting;
        }
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (this.virtualDepartureTime.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        double jobVirtualDepartureTime = this.getVirtualTime() + jobServiceTime;
        this.virtualDepartureTime.put(job, jobVirtualDepartureTime);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (!(job != null && this.getJobs().contains(job) && this.getJobsInServiceArea().contains(job) && this.virtualDepartureTime.containsKey(job))) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        if (jobServiceTime == 0.0 || Double.isFinite(jobServiceTime) && Double.isInfinite(time)) {
            this.depart(time, job);
        } else {
            this.rescheduleDepartureEvent();
        }
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        this.removeJobFromQueueUponRevokation(departingJob, time, false);
    }

    @Override
    protected void rescheduleAfterDeparture(J departedJob, double time) {
        if (departedJob == null) {
            throw new IllegalArgumentException();
        }
        this.rescheduleDepartureEvent();
    }

    protected final void rescheduleDepartureEvent() {
        Set<SimJQEvent.Departure> departureEvents = this.getDepartureEvents();
        if (departureEvents == null) {
            throw new RuntimeException();
        }
        if (departureEvents.size() > 1) {
            throw new IllegalStateException();
        }
        if (departureEvents.size() > 0) {
            this.cancelDepartureEvent(departureEvents.iterator().next());
        }
        if (!this.virtualDepartureTime.isEmpty()) {
            if (!this.hasJobsInServiceArea()) {
                throw new IllegalStateException();
            }
            if (Double.isInfinite(this.getLastUpdateTime())) {
                for (SimJob job : this.getJobsInServiceArea()) {
                    if (!Double.isFinite(this.getServiceTimeForJob(job))) continue;
                    throw new IllegalStateException();
                }
            } else {
                double scheduleVirtualTime = this.virtualDepartureTime.firstValue();
                double deltaVirtualTime = scheduleVirtualTime - this.getVirtualTime();
                if (deltaVirtualTime < 0.0) {
                    throw new IllegalStateException();
                }
                SimJob job = (SimJob)this.virtualDepartureTime.getPreImageForValue(scheduleVirtualTime).iterator().next();
                if (deltaVirtualTime == 0.0) {
                    this.depart(this.getLastUpdateTime(), job);
                } else if (Double.isFinite(deltaVirtualTime)) {
                    double deltaTime = deltaVirtualTime * (double)this.getNumberOfJobsInServiceArea();
                    this.scheduleDepartureEvent(this.getLastUpdateTime() + deltaTime, job);
                }
            }
        }
    }
}

