/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.processorsharing;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.AbstractProcessorSharingSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.SimQueueCatchUpEvent;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventList;

public class CUPS<J extends SimJob, Q extends CUPS>
extends AbstractProcessorSharingSimQueue<J, Q> {
    private static final Logger LOGGER = Logger.getLogger(CUPS.class.getName());
    public static final double TOLERANCE_OST = 1.0E-9;
    private final NavigableMap<Double, Set<J>> obtainedServiceTimeMap = new TreeMap<Double, Set<J>>();
    private double lastCatchUpTime = Double.NaN;
    protected final CatchUpEvent catchUpEvent = new CatchUpEvent(this, Double.NEGATIVE_INFINITY, event -> this.catchUp(event.getTime()));

    public CUPS(SimEventList eventList) {
        super(eventList, Integer.MAX_VALUE, 1);
        this.registerPreUpdateHook(this::updateObtainedServiceTime);
    }

    @Override
    public CUPS<J, Q> getCopySimQueue() {
        return new CUPS<J, Q>(this.getEventList());
    }

    @Override
    public String toStringDefault() {
        return "CUPS";
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    protected final Set<J> getJobsExecuting() {
        if (this.hasJobsInServiceArea()) {
            return this.obtainedServiceTimeMap.firstEntry().getValue();
        }
        return Collections.EMPTY_SET;
    }

    protected final int getNumberOfJobsExecuting() {
        return this.getJobsExecuting().size();
    }

    protected final double getMinimumObtainedServiceTime() {
        if (!this.hasJobsInServiceArea()) {
            throw new IllegalStateException();
        }
        return (Double)this.obtainedServiceTimeMap.firstKey();
    }

    protected final void removeJobFromInternalAdministration(J job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.sanityInternalAdministration();
        if (!this.isJobInServiceArea((SimJob)job)) {
            return;
        }
        Iterator ost_i = this.obtainedServiceTimeMap.entrySet().iterator();
        while (ost_i.hasNext()) {
            Map.Entry entry = ost_i.next();
            Set jobs = (Set)entry.getValue();
            if (!jobs.contains(job)) continue;
            jobs.remove(job);
            if (jobs.isEmpty()) {
                ost_i.remove();
            }
            return;
        }
        throw new IllegalStateException();
    }

    protected final double getTimeToCatchUp() {
        this.sanityInternalAdministration();
        if (this.obtainedServiceTimeMap.size() < 2) {
            throw new IllegalStateException();
        }
        Iterator ost_i = this.obtainedServiceTimeMap.entrySet().iterator();
        Map.Entry entry_first = ost_i.next();
        Map.Entry entry_second = ost_i.next();
        double ost_first = (Double)entry_first.getKey();
        double ost_second = (Double)entry_second.getKey();
        double diff_ost = ost_second - ost_first;
        if (diff_ost <= 0.0) {
            throw new IllegalStateException();
        }
        return diff_ost * (double)this.getNumberOfJobsExecuting();
    }

    protected final void sanityInternalAdministration() {
        LOGGER.log(Level.FINER, "t={0}, sanity on {1}: jobsInServiceArea={2}; obtainedServiceTimeMap={3}.", new Object[]{this.getLastUpdateTime(), this, this.getJobsInServiceArea(), this.obtainedServiceTimeMap});
        if (this.obtainedServiceTimeMap == null) {
            throw new IllegalStateException();
        }
        int numberOfJobsInObtainedServiceTimeMap = 0;
        for (Set jobs : this.obtainedServiceTimeMap.values()) {
            numberOfJobsInObtainedServiceTimeMap += jobs.size();
        }
        if (numberOfJobsInObtainedServiceTimeMap != this.getNumberOfJobsInServiceArea()) {
            throw new IllegalStateException();
        }
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.obtainedServiceTimeMap.clear();
        this.lastCatchUpTime = Double.NaN;
    }

    protected final void updateObtainedServiceTime(double newTime) {
        if (newTime < this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        this.sanityInternalAdministration();
        if (newTime == this.getLastUpdateTime()) {
            return;
        }
        if (this.hasJobsInServiceArea()) {
            double ost_old = (Double)this.obtainedServiceTimeMap.firstKey();
            int numberOfJobsExecuting = this.obtainedServiceTimeMap.firstEntry().getValue().size();
            double ost_new = ost_old + (newTime - this.getLastUpdateTime()) / (double)numberOfJobsExecuting;
            Set jobs_ost_old = (Set)this.obtainedServiceTimeMap.get(ost_old);
            if (this.obtainedServiceTimeMap.size() > 1) {
                double ost_runner_up = this.obtainedServiceTimeMap.higherKey(ost_old);
                this.obtainedServiceTimeMap.remove(ost_old);
                if (ost_new > ost_runner_up + 1.0E-9) {
                    throw new IllegalStateException();
                }
                if (ost_new >= ost_runner_up - 1.0E-9) {
                    ((Set)this.obtainedServiceTimeMap.get(ost_runner_up)).addAll(jobs_ost_old);
                    this.lastCatchUpTime = newTime;
                } else {
                    this.obtainedServiceTimeMap.put(ost_new, jobs_ost_old);
                }
            } else {
                this.obtainedServiceTimeMap.remove(ost_old);
                this.obtainedServiceTimeMap.put(ost_new, jobs_ost_old);
            }
        }
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (job == null || !this.getJobsInWaitingArea().contains(job)) {
            throw new IllegalArgumentException();
        }
        if (this.hasServerAcccessCredits()) {
            this.start(time, job);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        this.removeJobFromInternalAdministration(job);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.rescheduleDepartureEvent();
        this.rescheduleCatchUpEvent();
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        while (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea()) {
            this.start(time, this.getFirstJobInWaitingArea());
        }
    }

    @Override
    public final boolean isStartArmed() {
        return true;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        this.sanityInternalAdministration();
        double jobRequiredServiceTime = this.getServiceTimeForJob(job);
        if (jobRequiredServiceTime < 0.0) {
            throw new RuntimeException();
        }
        if (!this.obtainedServiceTimeMap.containsKey(0.0)) {
            this.obtainedServiceTimeMap.put(0.0, new LinkedHashSet());
        }
        ((Set)this.obtainedServiceTimeMap.get(0.0)).add(job);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (job == null || !this.getJobs().contains(job) || !this.getJobsInServiceArea().contains(job)) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        if (jobServiceTime == 0.0 || Double.isFinite(jobServiceTime) && Double.isInfinite(time)) {
            this.depart(time, job);
        } else {
            this.rescheduleDepartureEvent();
            this.rescheduleCatchUpEvent();
        }
        this.sanityInternalAdministration();
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    protected final void catchUp(double time) {
        if (!Double.isNaN(this.lastCatchUpTime) && this.lastCatchUpTime > time) {
            throw new IllegalStateException();
        }
        boolean recentCatchUp = !Double.isNaN(this.lastCatchUpTime) && this.lastCatchUpTime >= time - 1.0E-9;
        int oldObtainedServiceTimeMapSize = this.obtainedServiceTimeMap.size();
        if (oldObtainedServiceTimeMapSize < 2 && !recentCatchUp) {
            throw new IllegalStateException("illegally scheduled catch-up event at t=" + time + ", old obtained service-time map: " + this.obtainedServiceTimeMap + ".");
        }
        this.update(time);
        if (this.obtainedServiceTimeMap.size() != oldObtainedServiceTimeMapSize - 1 && !recentCatchUp) {
            throw new IllegalStateException("missed catch-up at t=" + time + ": old number of groups: " + oldObtainedServiceTimeMapSize + ", new obtained service-time map: " + this.obtainedServiceTimeMap + ".");
        }
        this.rescheduleDepartureEvent();
        this.rescheduleCatchUpEvent();
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        this.removeJobFromQueueUponRevokation(departingJob, time, false);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        if (departedJob == null) {
            throw new IllegalArgumentException();
        }
        this.rescheduleDepartureEvent();
        this.rescheduleCatchUpEvent();
    }

    protected final void rescheduleDepartureEvent() {
        Set<SimJQEvent.Departure> departureEvents = this.getDepartureEvents();
        if (departureEvents == null) {
            throw new RuntimeException();
        }
        if (departureEvents.size() > 1) {
            throw new IllegalStateException();
        }
        if (departureEvents.size() > 0) {
            this.cancelDepartureEvent(departureEvents.iterator().next());
        }
        this.sanityInternalAdministration();
        if (this.hasJobsInServiceArea()) {
            Set<J> jobsExecuting = this.getJobsExecuting();
            if (jobsExecuting.isEmpty()) {
                throw new IllegalStateException();
            }
            if (Double.isInfinite(this.getLastUpdateTime())) {
                for (SimJob job : this.getJobsInServiceArea()) {
                    if (!Double.isFinite(this.getServiceTimeForJob(job))) continue;
                    throw new IllegalStateException();
                }
            } else {
                boolean first = true;
                SimJob leaver = null;
                double rst_leaver = Double.POSITIVE_INFINITY;
                for (SimJob job : jobsExecuting) {
                    if (first) {
                        first = false;
                        leaver = job;
                        rst_leaver = this.getServiceTimeForJob(job);
                        continue;
                    }
                    double rst_job = this.getServiceTimeForJob(job);
                    if (!(rst_job < rst_leaver)) continue;
                    leaver = job;
                    rst_leaver = rst_job;
                }
                if (Double.isFinite(rst_leaver)) {
                    int numberOfJobsExecuting = jobsExecuting.size();
                    double ost = this.getMinimumObtainedServiceTime();
                    double timeToDeparture = Math.max(rst_leaver - ost, 0.0) * (double)numberOfJobsExecuting;
                    this.scheduleDepartureEvent(this.getLastUpdateTime() + timeToDeparture, leaver);
                }
            }
        }
    }

    protected final void cancelCatchUpEvent() {
        this.getEventList().remove((Object)this.catchUpEvent);
        this.eventsScheduled.remove((Object)this.catchUpEvent);
    }

    protected final void rescheduleCatchUpEvent() {
        this.cancelCatchUpEvent();
        if (this.obtainedServiceTimeMap.size() >= 2) {
            double time = this.getLastUpdateTime();
            double timeToCatchUp = this.getTimeToCatchUp();
            if (Double.isFinite(time) && Double.isFinite(timeToCatchUp)) {
                this.getEventList().schedule(time + timeToCatchUp, (SimEvent)this.catchUpEvent);
                this.eventsScheduled.add(this.catchUpEvent);
            }
        }
    }

    protected static final class CatchUpEvent
    extends SimQueueCatchUpEvent {
        public CatchUpEvent(CUPS queue, double catchUpTime, SimEventAction action) {
            super(queue, catchUpTime, action);
        }
    }
}

