/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.processorsharing;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.AbstractProcessorSharingSimQueue;
import org.javades.jsimulation.r5.SimEventList;

public class SocPS<J extends SimJob, Q extends SocPS>
extends AbstractProcessorSharingSimQueue<J, Q> {
    private static final Logger LOGGER = Logger.getLogger(SocPS.class.getName());
    public static final double TOLERANCE_RST = 1.0E-9;
    protected final Map<J, Double> remainingServiceTime = new HashMap<J, Double>();

    public SocPS(SimEventList eventList) {
        super(eventList, Integer.MAX_VALUE, 1);
        this.registerPreUpdateHook(this::updateRemainingServiceTimes);
    }

    @Override
    public SocPS<J, Q> getCopySimQueue() {
        return new SocPS<J, Q>(this.getEventList());
    }

    @Override
    public String toStringDefault() {
        return "SocPS";
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    protected final double getRemainingWork() {
        double remainingWork = 0.0;
        for (double remainingWork_j : this.remainingServiceTime.values()) {
            remainingWork += remainingWork_j;
        }
        return remainingWork;
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.remainingServiceTime.clear();
    }

    protected final void updateRemainingServiceTimes(double newTime) {
        if (newTime < this.getLastUpdateTime()) {
            throw new IllegalStateException();
        }
        if (newTime == this.getLastUpdateTime()) {
            return;
        }
        double dT = newTime - this.getLastUpdateTime();
        double oldRemainingWork = this.getRemainingWork();
        for (SimJob job : this.getJobsInServiceArea()) {
            double newRst_j;
            if (!this.remainingServiceTime.containsKey(job)) {
                throw new IllegalStateException();
            }
            if (oldRemainingWork < 1.0E-9) {
                newRst_j = 0.0;
            } else {
                double oldRst_j = this.remainingServiceTime.get(job);
                if (oldRst_j < 0.0) {
                    throw new IllegalStateException();
                }
                newRst_j = oldRst_j - oldRst_j / oldRemainingWork * dT;
                if (newRst_j < -1.0E-9) {
                    throw new IllegalStateException();
                }
                if (newRst_j < 0.0) {
                    newRst_j = 0.0;
                }
            }
            this.remainingServiceTime.put(job, newRst_j);
        }
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (job == null || !this.getJobsInWaitingArea().contains(job)) {
            throw new IllegalArgumentException();
        }
        if (this.hasServerAcccessCredits()) {
            this.start(time, job);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isJob((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        this.remainingServiceTime.remove(job);
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        this.rescheduleDepartureEvent();
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        while (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea()) {
            this.start(time, this.getFirstJobInWaitingArea());
        }
    }

    @Override
    public final boolean isStartArmed() {
        return true;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.getJobs().contains(job) || this.isJobInServiceArea((SimJob)job) || this.remainingServiceTime.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        double jobRequiredServiceTime = this.getServiceTimeForJob(job);
        if (jobRequiredServiceTime < 0.0) {
            throw new RuntimeException();
        }
        this.remainingServiceTime.put(job, jobRequiredServiceTime);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (!(job != null && this.getJobs().contains(job) && this.getJobsInServiceArea().contains(job) && this.remainingServiceTime.containsKey(job))) {
            throw new IllegalArgumentException();
        }
        this.rescheduleDepartureEvent();
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        this.removeJobFromQueueUponRevokation(departingJob, time, false);
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        if (departedJob == null || this.isJob((SimJob)departedJob) || this.isJobInServiceArea((SimJob)departedJob) || this.remainingServiceTime.containsKey(departedJob)) {
            throw new IllegalArgumentException();
        }
        if (this.hasJobsInServiceArea()) {
            this.depart(time, this.getFirstJobInServiceArea());
        }
    }

    protected final void rescheduleDepartureEvent() {
        Set<SimJQEvent.Departure> departureEvents = this.getDepartureEvents();
        if (departureEvents == null) {
            throw new RuntimeException();
        }
        if (departureEvents.size() > 1) {
            throw new IllegalStateException();
        }
        if (departureEvents.size() > 0) {
            this.cancelDepartureEvent(departureEvents.iterator().next());
        }
        double time = this.getLastUpdateTime();
        double remainingWork = this.getRemainingWork();
        if (this.hasJobsInServiceArea() && Double.isFinite(remainingWork)) {
            if (Double.isInfinite(time)) {
                if (this.getNumberOfJobsInServiceArea() > 1) {
                    throw new IllegalStateException();
                }
                this.depart(time, this.getFirstJobInServiceArea());
                if (this.hasJobsInServiceArea()) {
                    throw new IllegalStateException();
                }
            } else if (remainingWork < 1.0E-9) {
                this.depart(time, this.getFirstJobInServiceArea());
                if (this.hasJobsInServiceArea()) {
                    throw new IllegalStateException();
                }
            } else {
                this.scheduleDepartureEvent(time + remainingWork, this.getFirstJobInServiceArea());
            }
        }
    }
}

