/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.qos;

import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.qos.AbstractSimQueueQoS;
import org.javades.jqueues.r5.entity.jq.queue.qos.SimQueueQoSUtils;
import org.javades.jqueues.r5.extensions.qos.SimQueueQoS;
import org.javades.jsimulation.r5.SimEventList;

public class HOL<J extends SimJob, Q extends HOL, P extends Comparable>
extends AbstractSimQueueQoS<J, Q, P>
implements SimQueueQoS<J, Q, P> {
    protected final NavigableMap<P, Set<J>> jobsQoSMap = new TreeMap<P, Set<J>>();

    public HOL(SimEventList eventList, Class<P> qosClass, P defaultJobQoS) {
        super(eventList, qosClass, defaultJobQoS);
    }

    @Override
    public HOL<J, Q, P> getCopySimQueue() throws UnsupportedOperationException {
        return new HOL<J, Q, Object>(this.getEventList(), this.getQoSClass(), this.getDefaultJobQoS());
    }

    @Override
    public String toStringDefault() {
        return "HOL";
    }

    @Override
    public final NavigableMap<P, Set<J>> getJobsQoSMap() {
        return this.jobsQoSMap;
    }

    protected final J getNextJobToServeInWaitingArea() {
        for (Set jobsP : this.jobsQoSMap.values()) {
            if (jobsP == null || jobsP.isEmpty()) {
                throw new IllegalStateException();
            }
            for (SimJob job : jobsP) {
                if (job == null || !this.isJob(job)) {
                    throw new IllegalStateException();
                }
                if (this.isJobInServiceArea(job)) continue;
                return (J)job;
            }
        }
        return null;
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.jobsQoSMap.clear();
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        Comparable qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(job, this);
        if (!this.jobsQoSMap.containsKey(qos)) {
            this.jobsQoSMap.put(qos, new LinkedHashSet());
        }
        ((Set)this.jobsQoSMap.get(qos)).add(job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (this.hasServerAcccessCredits() && !this.hasJobsInServiceArea()) {
            this.start(time, job);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        Comparable qos;
        if (this.isJobInServiceArea((SimJob)job)) {
            this.cancelDepartureEvent(job);
        }
        if (!this.jobsQoSMap.containsKey(qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(job, this))) {
            throw new IllegalStateException();
        }
        if (this.jobsQoSMap.get(qos) == null || !((Set)this.jobsQoSMap.get(qos)).contains(job)) {
            throw new IllegalStateException();
        }
        ((Set)this.jobsQoSMap.get(qos)).remove(job);
        if (((Set)this.jobsQoSMap.get(qos)).isEmpty()) {
            this.jobsQoSMap.remove(qos);
        }
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea() && this.getNumberOfJobsInServiceArea() == 0) {
            this.start(time, this.getNextJobToServeInWaitingArea());
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        if (this.hasJobsInWaitingArea() && this.getNumberOfJobsInServiceArea() == 0) {
            this.start(time, this.getNextJobToServeInWaitingArea());
        }
    }

    @Override
    public final boolean isStartArmed() {
        return this.getNumberOfJobsInServiceArea() == 0;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.getJobs().contains(job) || this.getJobsInServiceArea().contains(job)) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (job == null || !this.isJob((SimJob)job) || !this.isJobInServiceArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(jobServiceTime)) {
            if (jobServiceTime == 0.0 || !Double.isFinite(time)) {
                this.depart(time, job);
            } else {
                this.rescheduleDepartureEvent();
            }
        }
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
        Comparable qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(departingJob, this);
        if (!this.jobsQoSMap.containsKey(qos)) {
            throw new IllegalStateException();
        }
        if (this.jobsQoSMap.get(qos) == null || !((Set)this.jobsQoSMap.get(qos)).contains(departingJob)) {
            throw new IllegalStateException();
        }
        ((Set)this.jobsQoSMap.get(qos)).remove(departingJob);
        if (((Set)this.jobsQoSMap.get(qos)).isEmpty()) {
            this.jobsQoSMap.remove(qos);
        }
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        if (this.hasJobsInServiceArea()) {
            throw new IllegalStateException();
        }
        if (this.hasServerAcccessCredits() && this.hasJobsInWaitingArea()) {
            this.start(time, this.getNextJobToServeInWaitingArea());
        }
    }

    protected final void rescheduleDepartureEvent() {
        Set<SimJQEvent.Departure> departureEvents = this.getDepartureEvents();
        if (departureEvents == null) {
            throw new RuntimeException();
        }
        if (departureEvents.size() > 1) {
            throw new IllegalStateException();
        }
        if (departureEvents.size() > 0) {
            this.cancelDepartureEvent(departureEvents.iterator().next());
        }
        if (this.getNumberOfJobsInServiceArea() > 1) {
            throw new IllegalStateException();
        }
        if (this.getNumberOfJobsInServiceArea() == 1) {
            Object job = this.getFirstJobInServiceArea();
            double time = this.getLastUpdateTime();
            double jobServiceTime = this.getServiceTimeForJob(job);
            if (Double.isFinite(jobServiceTime)) {
                if (jobServiceTime == 0.0 || Double.isInfinite(time)) {
                    this.depart(time, job);
                } else {
                    this.scheduleDepartureEvent(time + jobServiceTime, job);
                }
            }
        }
    }
}

