/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.qos;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.AbstractEgalitarianProcessorSharingSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.qos.SimQueueQoSUtils;
import org.javades.jqueues.r5.extensions.qos.SimQueueQoS;
import org.javades.jsimulation.r5.SimEventList;

public class HOL_PS<J extends SimJob, Q extends HOL_PS, P>
extends AbstractEgalitarianProcessorSharingSimQueue<J, Q>
implements SimQueueQoS<J, Q, P> {
    private final Class<P> qosClass;
    private final P defaultJobQoS;
    protected final Map<P, Set<J>> jobsQoSMap = new HashMap<P, Set<J>>();

    public HOL_PS(SimEventList eventList, Class<P> qosClass, P defaultJobQoS) {
        super(eventList, Integer.MAX_VALUE, 1);
        if (qosClass == null || defaultJobQoS == null) {
            throw new IllegalArgumentException();
        }
        this.qosClass = qosClass;
        this.defaultJobQoS = defaultJobQoS;
    }

    @Override
    public HOL_PS<J, Q, P> getCopySimQueue() {
        return new HOL_PS<J, Q, P>(this.getEventList(), this.getQoSClass(), this.getDefaultJobQoS());
    }

    @Override
    public String toStringDefault() {
        return "HOL-PS";
    }

    @Override
    public final Class<? extends P> getQoSClass() {
        return this.qosClass;
    }

    @Override
    public final void setQoSClass(Class<? extends P> qosClass) {
        SimQueueQoS.super.setQoSClass(qosClass);
    }

    @Override
    public final P getQoS() {
        return null;
    }

    @Override
    public final void setQoS(P qos) {
        SimQueueQoS.super.setQoS(qos);
    }

    @Override
    public final P getDefaultJobQoS() {
        return this.defaultJobQoS;
    }

    @Override
    public final Map<P, Set<J>> getJobsQoSMap() {
        return this.jobsQoSMap;
    }

    @Override
    protected void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.jobsQoSMap.clear();
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        Object qos = SimQueueQoSUtils.getAndCheckJobQoS(job, this);
        if (!this.jobsQoSMap.containsKey(qos)) {
            this.jobsQoSMap.put(qos, new LinkedHashSet());
        }
        this.jobsQoSMap.get(qos).add(job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (job == null || !this.isJobInWaitingArea((SimJob)job)) {
            throw new IllegalArgumentException();
        }
        if (this.hasServerAcccessCredits()) {
            Object qos = SimQueueQoSUtils.getAndCheckJobQoS(job, this);
            if (!this.jobsQoSMap.get(qos).contains(job)) {
                throw new IllegalArgumentException();
            }
            if (this.jobsQoSMap.get(qos).size() == 1) {
                this.start(time, job);
            } else if (!this.isJobInServiceArea((SimJob)this.jobsQoSMap.get(qos).iterator().next())) {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        Object qos;
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (this.isJobInServiceArea((SimJob)job)) {
            if (!this.virtualDepartureTime.containsKey(job)) {
                throw new IllegalStateException();
            }
            this.virtualDepartureTime.remove(job);
        }
        if (!this.jobsQoSMap.get(qos = SimQueueQoSUtils.getAndCheckJobQoS(job, this)).contains(job)) {
            throw new IllegalArgumentException();
        }
        this.jobsQoSMap.get(qos).remove(job);
        if (this.jobsQoSMap.get(qos).isEmpty()) {
            this.jobsQoSMap.remove(qos);
        }
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        Object qos = SimQueueQoSUtils.getAndCheckJobQoS(job, this);
        if (this.jobsQoSMap.containsKey(qos) && this.hasServerAcccessCredits() && !this.isJobInServiceArea((SimJob)this.jobsQoSMap.get(qos).iterator().next())) {
            this.start(time, (SimJob)this.jobsQoSMap.get(qos).iterator().next());
        } else {
            this.rescheduleDepartureEvent();
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        boolean hasStartableJobs = this.hasJobsInWaitingArea();
        while (hasStartableJobs) {
            boolean hasStartedJob = false;
            for (SimJob job : this.getJobsInWaitingArea()) {
                Object qos = SimQueueQoSUtils.getAndCheckJobQoS(job, this);
                if (!this.jobsQoSMap.containsKey(qos)) {
                    throw new IllegalStateException();
                }
                if (this.isJobInServiceArea((SimJob)this.jobsQoSMap.get(qos).iterator().next())) continue;
                this.start(time, (SimJob)this.jobsQoSMap.get(qos).iterator().next());
                hasStartedJob = true;
                break;
            }
            hasStartableJobs = hasStartedJob && this.hasServerAcccessCredits();
        }
    }

    @Override
    public final boolean isStartArmed() {
        return this.getNumberOfJobs() == 0;
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
        this.rescheduleAfterRevokation(departedJob, time, false);
    }
}

