/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.qos;

import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jqueues.r5.entity.jq.queue.qos.AbstractPreemptiveSimQueueQoS;
import org.javades.jqueues.r5.entity.jq.queue.qos.SimQueueQoSUtils;
import org.javades.jsimulation.r5.SimEventList;

public class PQ<J extends SimJob, Q extends PQ, P extends Comparable>
extends AbstractPreemptiveSimQueueQoS<J, Q, P> {
    protected final NavigableMap<P, Set<J>> jobsQoSMap = new TreeMap<P, Set<J>>();

    public PQ(SimEventList eventList, PreemptionStrategy preemptionStrategy, Class<P> qosClass, P defaultJobQoS) {
        super(eventList, Integer.MAX_VALUE, 1, preemptionStrategy, qosClass, defaultJobQoS);
    }

    @Override
    public PQ<J, Q, P> getCopySimQueue() {
        return new PQ<J, Q, Object>(this.getEventList(), this.getPreemptionStrategy(), this.getQoSClass(), this.getDefaultJobQoS());
    }

    @Override
    public String toStringDefault() {
        return "PQ[" + (Object)((Object)this.getPreemptionStrategy()) + "]";
    }

    @Override
    public final NavigableMap<P, Set<J>> getJobsQoSMap() {
        return this.jobsQoSMap;
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.jobsQoSMap.clear();
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
        Comparable qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(job, this);
        if (!this.jobsQoSMap.containsKey(qos)) {
            this.jobsQoSMap.put(qos, new LinkedHashSet());
        }
        ((Set)this.jobsQoSMap.get(qos)).add(job);
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        Comparable qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(job, this);
        if (!((Set)this.jobsQoSMap.get(qos)).contains(job)) {
            throw new IllegalStateException();
        }
        if (this.getExecutableJobWithHighestPriority() == job) {
            this.start(time, job);
        }
    }

    @Override
    protected final void setServerAccessCreditsSubClass() {
        super.setServerAccessCreditsSubClass();
    }

    @Override
    protected final void rescheduleForNewServerAccessCredits(double time) {
        this.reschedule();
    }

    @Override
    public final boolean isStartArmed() {
        return this.getNumberOfJobsInServiceArea() == 0;
    }

    @Override
    protected final void insertJobInQueueUponStart(J job, double time) {
        if (job == null || !this.isJob((SimJob)job) || this.isJobInServiceArea((SimJob)job) || this.remainingServiceTime.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = this.getServiceTimeForJob(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        this.remainingServiceTime.put(job, jobServiceTime);
    }

    @Override
    protected final void rescheduleAfterStart(J job, double time) {
        if (!(job != null && this.isJob((SimJob)job) && this.isJobInServiceArea((SimJob)job) && this.remainingServiceTime.containsKey(job))) {
            throw new IllegalArgumentException();
        }
        double jobServiceTime = (Double)this.remainingServiceTime.get(job);
        if (jobServiceTime < 0.0) {
            throw new RuntimeException();
        }
        this.reschedule();
    }

    @Override
    protected final double getServiceTimeForJob(J job) {
        return super.getServiceTimeForJob(job);
    }

    @Override
    protected final void removeJobFromQueueUponExit(J exitingJob, double time) {
        Comparable qos;
        if (exitingJob == null || !this.isJob((SimJob)exitingJob)) {
            throw new IllegalArgumentException();
        }
        if (this.isJobInServiceArea((SimJob)exitingJob)) {
            if (!this.remainingServiceTime.containsKey(exitingJob)) {
                throw new IllegalStateException();
            }
            this.remainingServiceTime.remove(exitingJob);
            if (this.jobsBeingServed.containsKey(exitingJob)) {
                if (!this.getDepartureEvents(exitingJob).isEmpty()) {
                    if (this.getDepartureEvents(exitingJob).size() > 1) {
                        throw new IllegalStateException();
                    }
                    this.cancelDepartureEvent(exitingJob);
                }
                this.jobsBeingServed.remove(exitingJob);
            }
        }
        if (!this.jobsQoSMap.containsKey(qos = (Comparable)SimQueueQoSUtils.getAndCheckJobQoS(exitingJob, this))) {
            throw new IllegalStateException();
        }
        if (!((Set)this.jobsQoSMap.get(qos)).contains(exitingJob)) {
            throw new IllegalStateException();
        }
        ((Set)this.jobsQoSMap.get(qos)).remove(exitingJob);
        if (((Set)this.jobsQoSMap.get(qos)).isEmpty()) {
            this.jobsQoSMap.remove(qos);
        }
    }

    @Override
    protected final void rescheduleAfterExit(double time) {
        this.reschedule();
    }

    protected final J getExecutableJobWithHighestPriority() {
        for (Set jobsP : this.jobsQoSMap.values()) {
            if (jobsP == null || jobsP.isEmpty()) {
                throw new IllegalStateException();
            }
            for (SimJob job : jobsP) {
                if (job == null || !this.isJob(job)) {
                    throw new IllegalStateException();
                }
                if (!this.isJobInServiceArea(job) && !this.hasServerAcccessCredits()) continue;
                return (J)job;
            }
        }
        return null;
    }

    protected final void reschedule() {
        if (this.jobsBeingServed.keySet().size() > 1) {
            throw new IllegalStateException();
        }
        SimJob jobBeingServed = this.jobsBeingServed.isEmpty() ? null : (SimJob)this.jobsBeingServed.keySet().iterator().next();
        J jobToServe = this.getExecutableJobWithHighestPriority();
        if (jobBeingServed != null && jobToServe == null) {
            throw new IllegalStateException();
        }
        if (jobBeingServed != jobToServe) {
            if (jobBeingServed != null) {
                this.preemptJob(this.getLastUpdateTime(), jobBeingServed);
                this.reschedule();
            } else if (!this.isJobInServiceArea((SimJob)jobToServe)) {
                this.start(this.getLastUpdateTime(), jobToServe);
            } else {
                this.startServiceChunk(this.getLastUpdateTime(), jobToServe);
            }
        }
    }
}

