/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.serverless;

import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.serverless.AbstractServerlessSimQueue;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventList;

public class ALIMIT<J extends SimJob, Q extends ALIMIT>
extends AbstractServerlessSimQueue<J, Q> {
    private final double rateLimit;
    private boolean isRateLimited = false;

    public ALIMIT(SimEventList eventList, double rateLimit) {
        super(eventList, Integer.MAX_VALUE);
        if (rateLimit < 0.0) {
            throw new IllegalArgumentException();
        }
        this.rateLimit = rateLimit;
        this.isRateLimited = this.rateLimit == 0.0;
    }

    @Override
    public ALIMIT<J, Q> getCopySimQueue() {
        return new ALIMIT<J, Q>(this.getEventList(), this.getRateLimit());
    }

    @Override
    public String toStringDefault() {
        return "ALIMIT[" + this.getRateLimit() + "]";
    }

    public final double getRateLimit() {
        return this.rateLimit;
    }

    protected final boolean isRateLimited() {
        return this.isRateLimited;
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.isRateLimited = this.rateLimit == 0.0;
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (!this.isRateLimited()) {
            this.depart(time, job);
            if (Double.isFinite(this.rateLimit)) {
                this.isRateLimited = true;
                this.scheduleRateLimitExpirationEvent(time + 1.0 / this.rateLimit);
            }
        } else {
            this.drop(job, time);
        }
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
        throw new IllegalStateException();
    }

    protected final void rateLimitExpiration(RateLimitExpirationEvent<Q> event) {
        if (event == null) {
            throw new RuntimeException();
        }
        if (!this.eventsScheduled.contains(event)) {
            throw new IllegalStateException();
        }
        this.eventsScheduled.remove(event);
        if (!this.isRateLimited) {
            throw new IllegalStateException();
        }
        this.isRateLimited = false;
    }

    protected final RateLimitExpirationEvent<Q> scheduleRateLimitExpirationEvent(double expirationTime) {
        if (expirationTime < this.getLastUpdateTime()) {
            throw new IllegalArgumentException();
        }
        RateLimitExpirationEvent<ALIMIT> event = new RateLimitExpirationEvent<ALIMIT>(expirationTime, this);
        SimJQEventScheduler.scheduleJQ(this.getEventList(), event);
        this.eventsScheduled.add(event);
        return event;
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
    }

    protected static final class RateLimitExpirationEvent<Q extends ALIMIT>
    extends SimQueueEvent<SimJob, Q> {
        public RateLimitExpirationEvent(double expirationTime, Q queue) {
            super("RateLimitExpiration@" + queue, expirationTime, queue, (SimEventAction<? extends SimEntity>)((SimEventAction)event -> queue.rateLimitExpiration((RateLimitExpirationEvent)event)));
        }

        public final RateLimitExpirationEvent<Q> copyForQueueAndJob(Q newQueue, SimJob newJob) {
            throw new UnsupportedOperationException();
        }
    }
}

