/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.entity.jq.queue.serverless;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.serverless.AbstractServerlessSimQueue;
import org.javades.jqueues.r5.extensions.gate.SimQueueGateEvent;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGate;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateListener;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateOperationUtils;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateSimpleEventType;
import org.javades.jsimulation.r5.SimEventList;

public class GATE<J extends SimJob, Q extends GATE>
extends AbstractServerlessSimQueue<J, Q>
implements SimQueueWithGate<J, Q> {
    private int gatePassageCredits = Integer.MAX_VALUE;
    private boolean previousGatePassageCreditsAvailability = true;

    public GATE(SimEventList eventList) {
        super(eventList, Integer.MAX_VALUE);
        this.registerOperation(SimQueueWithGateOperationUtils.GatePassageCreditsOperation.getInstance());
        this.registerNotificationType(SimQueueWithGateSimpleEventType.GATE_CLOSED, this::fireGateClosed);
        this.registerNotificationType(SimQueueWithGateSimpleEventType.GATE_OPEN, this::fireGateOpen);
        this.registerPreNotificationHook(this::gatePassageCreditsPreNotificationHook);
    }

    @Override
    public GATE<J, Q> getCopySimQueue() {
        return new GATE<J, Q>(this.getEventList());
    }

    @Override
    public String toStringDefault() {
        return "GATE";
    }

    @Override
    public int getGatePassageCredits() {
        return this.gatePassageCredits;
    }

    @Override
    public final void setGatePassageCredits(double time, int gatePassageCredits) {
        if (gatePassageCredits < 0) {
            throw new IllegalArgumentException();
        }
        int oldGatePassageCredits = this.gatePassageCredits;
        if (oldGatePassageCredits != gatePassageCredits) {
            boolean needsNotification;
            this.update(time);
            this.gatePassageCredits = gatePassageCredits;
            boolean lostCredits = oldGatePassageCredits > 0 && this.gatePassageCredits == 0;
            boolean regainedCredits = oldGatePassageCredits == 0 && this.gatePassageCredits > 0;
            boolean bl = needsNotification = lostCredits || regainedCredits;
            if (needsNotification) {
                if (!this.clearAndUnlockPendingNotificationsIfLocked()) {
                    throw new IllegalStateException();
                }
                while (this.gatePassageCredits > 0 && this.hasJobsInWaitingArea()) {
                    this.depart(time, this.getFirstJobInWaitingArea());
                    if (this.gatePassageCredits >= Integer.MAX_VALUE) continue;
                    --this.gatePassageCredits;
                }
                this.fireAndLockPendingNotifications();
            }
        }
    }

    private void gatePassageCreditsPreNotificationHook(List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> pendingNotifications) {
        boolean gatePassageCreditsAvailability;
        if (pendingNotifications == null) {
            throw new IllegalArgumentException();
        }
        for (Map<SimEntitySimpleEventType.Member, SimEntityEvent> entry : pendingNotifications) {
            SimEntitySimpleEventType.Member notificationType = entry.keySet().iterator().next();
            if (notificationType != SimQueueWithGateSimpleEventType.GATE_CLOSED && notificationType != SimQueueWithGateSimpleEventType.GATE_OPEN) continue;
            throw new IllegalArgumentException();
        }
        boolean bl = gatePassageCreditsAvailability = this.getGatePassageCredits() > 0;
        if (gatePassageCreditsAvailability != this.previousGatePassageCreditsAvailability) {
            double time = this.getLastUpdateTime();
            int gac = this.getGatePassageCredits();
            if (gatePassageCreditsAvailability) {
                pendingNotifications.add(Collections.singletonMap(SimQueueWithGateSimpleEventType.GATE_OPEN, new SimQueueGateEvent(this, time, gac)));
            } else {
                pendingNotifications.add(Collections.singletonMap(SimQueueWithGateSimpleEventType.GATE_CLOSED, new SimQueueGateEvent(this, time, gac)));
            }
        }
        this.previousGatePassageCreditsAvailability = gatePassageCreditsAvailability;
    }

    @Override
    public final Class getQoSClass() {
        return super.getQoSClass();
    }

    @Override
    public final Object getQoS() {
        return super.getQoS();
    }

    @Override
    protected final void resetEntitySubClass() {
        super.resetEntitySubClass();
        this.gatePassageCredits = Integer.MAX_VALUE;
        this.previousGatePassageCreditsAvailability = true;
    }

    @Override
    protected final void insertJobInQueueUponArrival(J job, double time) {
    }

    @Override
    protected final void rescheduleAfterArrival(J job, double time) {
        if (this.gatePassageCredits == 0) {
            return;
        }
        if (this.gatePassageCredits < Integer.MAX_VALUE) {
            --this.gatePassageCredits;
        }
        this.depart(time, job);
    }

    @Override
    protected final void removeJobFromQueueUponDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void rescheduleAfterDrop(J job, double time) {
        throw new IllegalStateException();
    }

    @Override
    protected final void removeJobFromQueueUponRevokation(J job, double time, boolean auto) {
    }

    @Override
    protected final void rescheduleAfterRevokation(J job, double time, boolean auto) {
    }

    @Override
    protected final void removeJobFromQueueUponDeparture(J departingJob, double time) {
    }

    @Override
    protected final void rescheduleAfterDeparture(J departedJob, double time) {
    }

    private void fireGateOpen(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueGateEvent)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueGateEvent)event).getGatePassageCredits() == 0) {
            throw new IllegalArgumentException();
        }
        GATE queue = (GATE)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueWithGateListener)) continue;
            ((SimQueueWithGateListener)l).notifyNewGateStatus(time, this, true);
        }
    }

    private void fireGateClosed(SimEntityEvent event) {
        if (event == null) {
            throw new IllegalArgumentException();
        }
        if (!(event instanceof SimQueueGateEvent)) {
            throw new IllegalArgumentException();
        }
        double time = this.getLastUpdateTime();
        if (event.getTime() != time || ((SimQueueGateEvent)event).getGatePassageCredits() > 0) {
            throw new IllegalArgumentException();
        }
        GATE queue = (GATE)((SimJQEvent)event).getQueue();
        if (queue == null || queue != this) {
            throw new IllegalArgumentException();
        }
        for (SimEntityListener l : this.getSimEntityListeners()) {
            if (!(l instanceof SimQueueWithGateListener)) continue;
            ((SimQueueWithGateListener)l).notifyNewGateStatus(time, this, false);
        }
    }
}

