/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.AbstractEncapsulatorSimQueue;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public abstract class AbstractSimQueuePredictor_Composite_Enc<Q extends AbstractEncapsulatorSimQueue>
extends AbstractSimQueuePredictor_Composite<Q> {
    protected final AbstractSimQueuePredictor subQueuePredictor;

    public AbstractSimQueuePredictor_Composite_Enc(AbstractSimQueuePredictor subQueuePredictor) {
        super(Collections.singletonList(subQueuePredictor));
        if (subQueuePredictor == null) {
            throw new IllegalArgumentException();
        }
        this.subQueuePredictor = subQueuePredictor;
    }

    @Override
    public SimQueueState<SimJob, Q> createQueueState(Q queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        if (subQueues.size() != 1) {
            throw new IllegalArgumentException();
        }
        DefaultSimQueueState subQueueState = (DefaultSimQueueState)this.subQueuePredictor.createQueueState((SimQueue)subQueues.get(0), isROEL);
        LinkedHashSet subQueueStates = new LinkedHashSet();
        queueState.registerHandler(new SimQueueCompositeStateHandler(((AbstractSimQueueComposite)queue).getQueues(), Collections.singleton(subQueueState)));
        return queueState;
    }

    @Override
    public void updateToTime(Q queue, SimQueueState queueState, double newTime) {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimQueue subQueue = ((AbstractEncapsulatorSimQueue)queue).getEncapsulatedQueue();
        DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(0);
        this.subQueuePredictor.updateToTime(subQueue, subQueueState, newTime);
        queueState.setTime(newTime);
    }

    @Override
    public double getNextQueueEventTimeBeyond(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) throws SimQueuePredictionException {
        LinkedHashSet<SimEntitySimpleEventType.Member> subQueueEventTypes;
        DefaultSimQueueState subQueueState;
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimQueue subQueue = ((AbstractEncapsulatorSimQueue)queue).getEncapsulatedQueue();
        double subQueueNextEventTime = this.subQueuePredictor.getNextQueueEventTimeBeyond(subQueue, subQueueState = queueStateHandler.getSubQueueState(0), subQueueEventTypes = new LinkedHashSet<SimEntitySimpleEventType.Member>());
        if (!Double.isNaN(subQueueNextEventTime)) {
            if (subQueueEventTypes.size() != 1) {
                throw new SimQueuePredictionAmbiguityException();
            }
            SimEntitySimpleEventType.Member nextEvent = (SimEntitySimpleEventType.Member)subQueueEventTypes.iterator().next();
            queueEventTypes.add(new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(subQueue, null, nextEvent, null, null));
        }
        return subQueueNextEventTime;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(Q queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (queueState.getJobs().contains(job)) {
                    SimQueue encQueue = (SimQueue)((AbstractSimQueueComposite)queue).getQueues().iterator().next();
                    if (!(job instanceof DefaultSimJob)) {
                        throw new UnsupportedOperationException();
                    }
                    ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(encQueue, job.getServiceTime(queue));
                    AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent encQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(encQueue, SimQueueSimpleEventType.ARRIVAL, null, job, null);
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(encQueueEvent)), visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean isJobInServiceArea = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !isJobInServiceArea) {
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        this.revokeJobs(time, queue, queueState, revocations, visitLogsSet);
                        for (int i = 0; i < ((AbstractSimQueueComposite)queue).getQueues().size(); ++i) {
                            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
                            if (!subQueueState.getJobs().contains(job)) continue;
                            SimQueue subQueue = (SimQueue)new ArrayList(((AbstractSimQueueComposite)queue).getQueues()).get(i);
                            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent subQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(subQueue, SimQueueSimpleEventType.REVOCATION, null, job, null);
                            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueEvent)), visitLogsSet);
                            break;
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                SimQueue encQueue = (SimQueue)((AbstractSimQueueComposite)queue).getQueues().iterator().next();
                AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent encQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(encQueue, SimQueueSimpleEventType.SERVER_ACCESS_CREDITS, null, null, newSac);
                this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(encQueueEvent)), visitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType instanceof AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent) {
                ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
                SimQueue subQueue = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueue;
                int subQueueIndex = subQueues.indexOf(subQueue);
                DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(subQueueIndex);
                SimEntitySimpleEventType.Member subQueueWorkloadEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueWorkloadEvent;
                SimEntitySimpleEventType.Member subQueueQueueEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueQueueEvent;
                SimJob job = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).job;
                Object argument = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).argument;
                HashSet subQueueVisitLogsSet = new HashSet();
                try {
                    if (subQueueWorkloadEvent != null) {
                        SimJQEvent subQueueEvent;
                        if (subQueueWorkloadEvent == SimQueueSimpleEventType.ARRIVAL) {
                            subQueueEvent = new SimJQEvent.Arrival<SimJob, SimQueue>(job, subQueue, time);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.REVOCATION) {
                            subQueueEvent = new SimJQEvent.Revocation<SimJob, SimQueue>(job, subQueue, time, true);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                            subQueueEvent = new SimQueueEvent.ServerAccessCredits(subQueue, time, (Integer)argument);
                        } else {
                            throw new RuntimeException();
                        }
                        WorkloadSchedule_SQ_SV_ROEL_U subQueueWorkloadSchedule = this.subQueuePredictor.createWorkloadSchedule_SQ_SV_ROEL_U(subQueue, new HashSet<SimJQEvent>(Collections.singleton(subQueueEvent)));
                        this.subQueuePredictor.doWorkloadEvents_SQ_SV_ROEL_U(subQueue, subQueueWorkloadSchedule, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueWorkloadEvent)), subQueueVisitLogsSet);
                    } else {
                        this.subQueuePredictor.doQueueEvents_SQ_SV_ROEL_U(subQueue, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueQueueEvent)), subQueueVisitLogsSet);
                    }
                }
                catch (WorkloadScheduleException e) {
                    throw new RuntimeException(e);
                }
                this.checkSubQueueVisitLogsSet(time, queue, queueState, visitLogsSet, subQueue, subQueueIndex, subQueueState, subQueueVisitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    protected void dropJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> drops, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) {
        queueState.doExits(time, drops, null, null, null, visitLogsSet);
    }

    protected void revokeJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> revokers, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) {
        queueState.doExits(time, null, revokers, null, null, visitLogsSet);
    }

    protected void startJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> starters, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        queueState.doStarts(time, starters);
    }

    protected void departJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> departers, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        queueState.doExits(time, null, null, departers, null, visitLogsSet);
    }

    protected void checkSubQueueVisitLogsSet(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet, SimQueue subQueue, int subQueueIndex, DefaultSimQueueState<SimJob, SimQueue> subQueueState, Set<JobQueueVisitLog<SimJob, Q>> subQueueVisitLogsSet) throws SimQueuePredictionException {
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        if (subQueueState.getJobsInServiceAreaMap().containsKey(time)) {
            Set started = (Set)subQueueState.getJobsInServiceAreaMap().get(time);
            for (SimJob j : started) {
                if (queueState.getJobsInServiceArea().contains(j)) continue;
                this.startJobs(time, queue, queueState, Collections.singleton(j), visitLogsSet);
            }
        }
        for (JobQueueVisitLog<SimJob, Q> jvl : subQueueVisitLogsSet) {
            if (!jvl.started || !queueState.getJobs().contains(jvl.job) && jvl.revoked || queueState.getJobsInServiceArea().contains(jvl.job)) continue;
            this.startJobs(time, queue, queueState, Collections.singleton(jvl.job), visitLogsSet);
        }
        for (JobQueueVisitLog<SimJob, Q> jvl : subQueueVisitLogsSet) {
            if (jvl.dropped) {
                this.dropJobs(time, queue, queueState, Collections.singleton(jvl.job), visitLogsSet);
                continue;
            }
            if (jvl.departed) {
                this.departJobs(time, queue, queueState, Collections.singleton(jvl.job), visitLogsSet);
                continue;
            }
            if (jvl.revoked) continue;
            throw new UnsupportedOperationException();
        }
    }
}

