/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.DefaultSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite;
import org.javades.jqueues.r5.entity.jq.queue.composite.AbstractSimQueueComposite_LocalStart;
import org.javades.jqueues.r5.extensions.composite.AbstractSimQueuePredictor_Composite;
import org.javades.jqueues.r5.extensions.composite.SimQueueCompositeStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.queues.SimQueuePredictor_Pattern;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public abstract class AbstractSimQueuePredictor_Composite_LocalStart<Q extends AbstractSimQueueComposite_LocalStart>
extends AbstractSimQueuePredictor_Composite<Q> {
    public AbstractSimQueuePredictor_Composite_LocalStart(List<AbstractSimQueuePredictor> subQueuePredictors) {
        super(subQueuePredictors);
        if (subQueuePredictors == null || subQueuePredictors.size() < 1) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public SimQueueState<SimJob, Q> createQueueState(Q queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        if (subQueues.size() != this.subQueuePredictors.size()) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<DefaultSimQueueState> subQueueStates = new LinkedHashSet<DefaultSimQueueState>();
        for (int i = 0; i < subQueues.size(); ++i) {
            SimQueue subQueue = (SimQueue)subQueues.get(i);
            AbstractSimQueuePredictor subQueuePredictor = (AbstractSimQueuePredictor)this.subQueuePredictors.get(i);
            DefaultSimQueueState subQueueState = (DefaultSimQueueState)subQueuePredictor.createQueueState(subQueue, isROEL);
            subQueueStates.add(subQueueState);
        }
        queueState.registerHandler(new SimQueueCompositeStateHandler(((AbstractSimQueueComposite)queue).getQueues(), subQueueStates));
        return queueState;
    }

    @Override
    public void updateToTime(Q queue, SimQueueState queueState, double newTime) {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        for (int i = 0; i < this.subQueuePredictors.size(); ++i) {
            SimQueue subQueue = (SimQueue)subQueues.get(i);
            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
            ((AbstractSimQueuePredictor)this.subQueuePredictors.get(i)).updateToTime(subQueue, subQueueState, newTime);
        }
        queueState.setTime(newTime);
    }

    @Override
    public double getNextQueueEventTimeBeyond(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) throws SimQueuePredictionException {
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        double minNextEventTime = Double.NaN;
        HashSet<SimQueue> subQueuesMinNextEventTime = new HashSet<SimQueue>();
        SimEntitySimpleEventType.Member nextEvent = null;
        for (int i = 0; i < this.subQueuePredictors.size(); ++i) {
            SimQueue subQueue = (SimQueue)subQueues.get(i);
            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
            LinkedHashSet<SimEntitySimpleEventType.Member> subQueueEventTypes = new LinkedHashSet<SimEntitySimpleEventType.Member>();
            double subQueueNextEventTime = ((AbstractSimQueuePredictor)this.subQueuePredictors.get(i)).getNextQueueEventTimeBeyond(subQueue, subQueueState, subQueueEventTypes);
            if (Double.isNaN(subQueueNextEventTime) || !Double.isNaN(minNextEventTime) && !(subQueueNextEventTime <= minNextEventTime)) continue;
            if (subQueueEventTypes.size() != 1) {
                throw new SimQueuePredictionAmbiguityException();
            }
            if (!Double.isNaN(minNextEventTime) && subQueueNextEventTime < minNextEventTime) {
                subQueuesMinNextEventTime.clear();
            }
            subQueuesMinNextEventTime.add(subQueue);
            nextEvent = (SimEntitySimpleEventType.Member)subQueueEventTypes.iterator().next();
            minNextEventTime = subQueueNextEventTime;
        }
        if (subQueuesMinNextEventTime.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        if (subQueuesMinNextEventTime.size() == 1) {
            queueEventTypes.add(new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent((SimQueue)subQueuesMinNextEventTime.iterator().next(), null, nextEvent, null, null));
        }
        return minNextEventTime;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(Q queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (queueState.getJobs().contains(job) && queueState.getServerAccessCredits() >= 1) {
                    this.startJobs(time, queue, queueState, arrivals, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    boolean interruptService = (Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job);
                    boolean isJobInServiceArea = queueState.getJobsInServiceArea().contains(job);
                    if (interruptService || !isJobInServiceArea) {
                        HashSet<SimJob> revocations = new HashSet<SimJob>();
                        revocations.add(job);
                        this.revokeJobs(time, queue, queueState, revocations, visitLogsSet);
                        for (int i = 0; i < ((AbstractSimQueueComposite)queue).getQueues().size(); ++i) {
                            DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(i);
                            if (!subQueueState.getJobs().contains(job)) continue;
                            SimQueue subQueue = (SimQueue)new ArrayList(((AbstractSimQueueComposite)queue).getQueues()).get(i);
                            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent subQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(subQueue, SimQueueSimpleEventType.REVOCATION, null, job, null);
                            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueEvent)), visitLogsSet);
                            break;
                        }
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                if (oldSac == 0 && newSac > 0) {
                    LinkedHashSet<SimJob> starters = new LinkedHashSet<SimJob>();
                    Iterator<SimJob> i_waiters = queueState.getJobsInWaitingAreaOrdered().iterator();
                    int remainingSac = newSac;
                    while ((remainingSac == Integer.MAX_VALUE || remainingSac > 0) && i_waiters.hasNext()) {
                        starters.add(i_waiters.next());
                        if (remainingSac == Integer.MAX_VALUE) continue;
                        --remainingSac;
                    }
                    this.startJobs(time, queue, queueState, starters, visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueCompositeStateHandler queueStateHandler = (SimQueueCompositeStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueCompositeHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType instanceof AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent) {
                ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
                SimQueue subQueue = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueue;
                int subQueueIndex = subQueues.indexOf(subQueue);
                DefaultSimQueueState subQueueState = queueStateHandler.getSubQueueState(subQueueIndex);
                AbstractSimQueuePredictor subQueuePredictor = (AbstractSimQueuePredictor)this.subQueuePredictors.get(subQueueIndex);
                SimEntitySimpleEventType.Member subQueueWorkloadEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueWorkloadEvent;
                SimEntitySimpleEventType.Member subQueueQueueEvent = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).subQueueQueueEvent;
                SimJob job = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).job;
                Object argument = ((AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent)eventType).argument;
                HashSet subQueueVisitLogsSet = new HashSet();
                try {
                    if (subQueueWorkloadEvent != null) {
                        SimJQEvent subQueueEvent;
                        if (subQueueWorkloadEvent == SimQueueSimpleEventType.ARRIVAL) {
                            subQueueEvent = new SimJQEvent.Arrival<SimJob, SimQueue>(job, subQueue, time);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.REVOCATION) {
                            subQueueEvent = new SimJQEvent.Revocation<SimJob, SimQueue>(job, subQueue, time, true);
                        } else if (subQueueWorkloadEvent == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                            subQueueEvent = new SimQueueEvent.ServerAccessCredits(subQueue, time, (Integer)argument);
                        } else {
                            throw new RuntimeException();
                        }
                        WorkloadSchedule_SQ_SV_ROEL_U subQueueWorkloadSchedule = subQueuePredictor.createWorkloadSchedule_SQ_SV_ROEL_U(subQueue, new HashSet<SimJQEvent>(Collections.singleton(subQueueEvent)));
                        subQueuePredictor.doWorkloadEvents_SQ_SV_ROEL_U(subQueue, subQueueWorkloadSchedule, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueWorkloadEvent)), subQueueVisitLogsSet);
                    } else {
                        subQueuePredictor.doQueueEvents_SQ_SV_ROEL_U(subQueue, subQueueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(subQueueQueueEvent)), subQueueVisitLogsSet);
                    }
                }
                catch (WorkloadScheduleException e) {
                    throw new RuntimeException(e);
                }
                this.checkSubQueueVisitLogsSet(time, queue, queueState, visitLogsSet, subQueue, subQueueIndex, subQueueState, subQueueVisitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    protected void dropJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> drops, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) {
        queueState.doExits(time, drops, null, null, null, visitLogsSet);
    }

    protected void revokeJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> revokers, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) {
        queueState.doExits(time, null, revokers, null, null, visitLogsSet);
    }

    protected void startJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> starters, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        queueState.doStarts(time, starters);
        SimQueue headQueue = (SimQueue)((AbstractSimQueueComposite)queue).getQueues().iterator().next();
        for (SimJob job : starters) {
            if (!(job instanceof DefaultSimJob)) {
                throw new UnsupportedOperationException();
            }
            if (!queueState.getJobs().contains(job)) continue;
            ((DefaultSimJob)job).setRequestedServiceTimeMappingForQueue(headQueue, job.getServiceTime(queue));
            AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent headQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(headQueue, SimQueueSimpleEventType.ARRIVAL, null, job, null);
            this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(headQueueEvent)), visitLogsSet);
        }
    }

    protected void departJobs(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<SimJob> departers, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        queueState.doExits(time, null, null, departers, null, visitLogsSet);
    }

    protected void checkSubQueueVisitLogsSet(double time, Q queue, SimQueueState<SimJob, Q> queueState, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet, SimQueue subQueue, int subQueueIndex, DefaultSimQueueState<SimJob, SimQueue> subQueueState, Set<JobQueueVisitLog<SimJob, Q>> subQueueVisitLogsSet) throws SimQueuePredictionException {
        ArrayList subQueues = new ArrayList(((AbstractSimQueueComposite)queue).getQueues());
        for (JobQueueVisitLog<SimJob, Q> jvl : subQueueVisitLogsSet) {
            if (jvl.dropped) {
                this.dropJobs(time, queue, queueState, Collections.singleton(jvl.job), visitLogsSet);
                continue;
            }
            if (jvl.departed) {
                if (subQueueIndex == subQueues.size() - 1 || this instanceof SimQueuePredictor_Pattern) {
                    this.departJobs(time, queue, queueState, Collections.singleton(jvl.job), visitLogsSet);
                    continue;
                }
                int nextSubQueueIndex = subQueueIndex + 1;
                SimQueue nextSubQueue = (SimQueue)subQueues.get(nextSubQueueIndex);
                AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent nextSubQueueEvent = new AbstractSimQueuePredictor_Composite.SubQueueSimpleEvent(nextSubQueue, SimQueueSimpleEventType.ARRIVAL, null, (SimJob)jvl.job, null);
                if (!(jvl.job instanceof DefaultSimJob)) {
                    throw new UnsupportedOperationException();
                }
                ((DefaultSimJob)jvl.job).setRequestedServiceTimeMappingForQueue(nextSubQueue, jvl.job.getServiceTime(queue));
                this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, new HashSet<SimEntitySimpleEventType.Member>(Collections.singleton(nextSubQueueEvent)), visitLogsSet);
                continue;
            }
            if (jvl.revoked) continue;
            throw new UnsupportedOperationException();
        }
    }
}

