/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.gate;

import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGate;
import org.javades.jsimulation.r5.SimEventAction;

public class SimQueueGateEvent<J extends SimJob, Q extends SimQueue>
extends SimJQEvent<J, Q> {
    private final int gatePassageCredits;

    private static <J extends SimJob, Q extends SimQueue> String createName(Q queue, int gatePassageCredits) {
        if (gatePassageCredits < 0) {
            throw new IllegalArgumentException();
        }
        if (!(queue instanceof SimQueueWithGate)) {
            return "GATE_NOP@" + queue;
        }
        if (gatePassageCredits == 0) {
            return "GATE_CLOSE@" + queue;
        }
        if (gatePassageCredits < Integer.MAX_VALUE) {
            return "GATE_OPEN[" + gatePassageCredits + "]@" + queue;
        }
        return "GATE_OPEN@" + queue;
    }

    private static <J extends SimJob, Q extends SimQueue> SimEventAction<J> createAction(Q queue, int gatePassageCredits) {
        if (queue == null || gatePassageCredits < 0) {
            throw new IllegalArgumentException();
        }
        return event -> {
            if (queue instanceof SimQueueWithGate) {
                ((SimQueueWithGate)queue).setGatePassageCredits(event.getTime(), gatePassageCredits);
            }
        };
    }

    public SimQueueGateEvent(Q queue, double time, int gatePassageCredits) {
        super(SimQueueGateEvent.createName(queue, gatePassageCredits), time, queue, null, SimQueueGateEvent.createAction(queue, gatePassageCredits));
        this.gatePassageCredits = gatePassageCredits;
    }

    @Override
    public SimJQEvent copyForQueueAndJob(Q newQueue, J newJob) {
        if (newJob != null) {
            throw new IllegalArgumentException();
        }
        return new SimQueueGateEvent<J, Q>(newQueue != null ? newQueue : this.getQueue(), this.getTime(), this.getGatePassageCredits());
    }

    public final int getGatePassageCredits() {
        return this.gatePassageCredits;
    }
}

