/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.gate;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.serverless.GATE;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateSimpleEventType;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateStateHandler;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateWorkloadScheduleHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.DefaultWorkloadSchedule;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleInvalidException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_GATE
extends AbstractSimQueuePredictor<GATE> {
    public String toString() {
        return "Predictor[GATE]";
    }

    @Override
    public boolean isStartArmed(GATE queue, SimQueueState<SimJob, GATE> queueState) {
        return false;
    }

    @Override
    public WorkloadSchedule_SQ_SV_ROEL_U createWorkloadSchedule_SQ_SV_ROEL_U(GATE queue, Set<SimJQEvent> workloadEvents) throws WorkloadScheduleException {
        WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule = super.createWorkloadSchedule_SQ_SV_ROEL_U(queue, workloadEvents);
        ((DefaultWorkloadSchedule)((Object)workloadSchedule)).registerHandler(new SimQueueWithGateWorkloadScheduleHandler());
        return workloadSchedule;
    }

    @Override
    public SimQueueState<SimJob, GATE> createQueueState(GATE queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        queueState.registerHandler(new SimQueueWithGateStateHandler());
        return queueState;
    }

    @Override
    public double getNextQueueEventTimeBeyond(GATE queue, SimQueueState<SimJob, GATE> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(GATE queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, GATE> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, GATE>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueWithGateWorkloadScheduleHandler workloadScheduleHandler = (SimQueueWithGateWorkloadScheduleHandler)((DefaultWorkloadSchedule)((Object)workloadSchedule)).getHandler("SimQueueWithGateHandler");
        SimQueueWithGateStateHandler queueStateHandler = (SimQueueWithGateStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueWithGateHandler");
        int oldPassages = queueStateHandler.getGatePassageCredits();
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                if (queueState.isQueueAccessVacation()) {
                    queueState.doArrivals(time, arrivals, visitLogsSet);
                } else if (oldPassages > 0) {
                    queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
                    if (oldPassages < Integer.MAX_VALUE) {
                        queueStateHandler.setGatePassageCredits(time, oldPassages - 1);
                    }
                } else {
                    queueState.doArrivals(time, arrivals, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
            } else if (eventType == SimQueueWithGateSimpleEventType.GATE) {
                int remainingPassages = (Integer)((List)workloadScheduleHandler.getGatePassageCreditsMap(queue).get(time)).get(0);
                if (oldPassages == 0 && remainingPassages > 0 && !queueState.getJobsInWaitingArea().isEmpty()) {
                    LinkedHashSet<SimJob> departures = new LinkedHashSet<SimJob>();
                    Iterator<SimJob> i_waiters = queueState.getJobsInWaitingAreaOrdered().iterator();
                    while ((remainingPassages == Integer.MAX_VALUE || remainingPassages > 0) && i_waiters.hasNext()) {
                        departures.add(i_waiters.next());
                        if (remainingPassages == Integer.MAX_VALUE) continue;
                        --remainingPassages;
                    }
                    queueState.doExits(time, null, null, departures, null, visitLogsSet);
                }
                queueStateHandler.setGatePassageCredits(time, remainingPassages);
            } else {
                throw new WorkloadScheduleInvalidException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(GATE queue, SimQueueState<SimJob, GATE> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, GATE>> visitLogsSet) throws SimQueuePredictionException {
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        throw new IllegalStateException();
    }

    @Override
    public void updateToTime(GATE queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        queueState.setTime(newTime);
    }
}

