/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.gate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.extensions.gate.SimQueueGateEvent;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateSimpleEventType;
import org.javades.jqueues.r5.util.predictor.workload.DefaultWorkloadSchedule;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleHandler;

public final class SimQueueWithGateWorkloadScheduleHandler
implements WorkloadScheduleHandler {
    private static final Map<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member> EVENT_MAP = new HashMap<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member>();
    private DefaultWorkloadSchedule workloadSchedule = null;
    private final Map<SimQueue, NavigableMap<Double, List<Integer>>> gatePassageCreditsTimesMap = new HashMap<SimQueue, NavigableMap<Double, List<Integer>>>();

    @Override
    public final String getHandlerName() {
        return "SimQueueWithGateHandler";
    }

    @Override
    public final Map<Class<? extends SimJQEvent>, SimEntitySimpleEventType.Member> getEventMap() {
        return EVENT_MAP;
    }

    @Override
    public final boolean needsScan() {
        return true;
    }

    @Override
    public final Set<SimJQEvent> scan(DefaultWorkloadSchedule workloadSchedule) throws WorkloadScheduleException {
        if (workloadSchedule == null) {
            throw new IllegalArgumentException();
        }
        if (this.workloadSchedule != null) {
            throw new IllegalStateException();
        }
        this.workloadSchedule = workloadSchedule;
        HashSet<SimJQEvent> processedQueueEvents = new HashSet<SimJQEvent>();
        for (SimQueue q : workloadSchedule.getQueues()) {
            this.gatePassageCreditsTimesMap.put(q, new TreeMap());
        }
        if (workloadSchedule.getQueueEvents() != null) {
            for (SimJQEvent event : workloadSchedule.getQueueEvents()) {
                double time = event.getTime();
                Object queue = event.getQueue();
                if (!workloadSchedule.getQueues().contains(queue) || !(event instanceof SimQueueGateEvent)) continue;
                processedQueueEvents.add(event);
                int credits = ((SimQueueGateEvent)event).getGatePassageCredits();
                NavigableMap<Double, List<Integer>> gateTimesMap_q = this.gatePassageCreditsTimesMap.get(queue);
                if (!gateTimesMap_q.containsKey(time)) {
                    gateTimesMap_q.put(time, new ArrayList());
                }
                ((List)gateTimesMap_q.get(time)).add(credits);
            }
        }
        return processedQueueEvents;
    }

    public final NavigableMap<Double, List<Integer>> getGatePassageCreditsMap(SimQueue queue) {
        if (this.workloadSchedule == null) {
            throw new IllegalStateException();
        }
        if (queue == null || !this.workloadSchedule.getQueues().contains(queue) || !this.gatePassageCreditsTimesMap.containsKey(queue)) {
            return Collections.unmodifiableNavigableMap(new TreeMap());
        }
        return Collections.unmodifiableNavigableMap(this.gatePassageCreditsTimesMap.get(queue));
    }

    static {
        EVENT_MAP.put(SimQueueGateEvent.class, SimQueueWithGateSimpleEventType.GATE);
    }
}

