/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.ost;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueStateHandler;

public final class SimQueueOSTStateHandler
implements SimQueueStateHandler {
    private DefaultSimQueueState queueState = null;
    private final Map<SimJob, Double> ost_j = new LinkedHashMap<SimJob, Double>();
    private final NavigableMap<Double, Set<SimJob>> jobs_ost = new TreeMap<Double, Set<SimJob>>();

    @Override
    public final String getHandlerName() {
        return "SimQueueOSTHandler";
    }

    @Override
    public final void initHandler(DefaultSimQueueState queueState) {
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        if (this.queueState != null) {
            throw new IllegalStateException();
        }
        this.queueState = queueState;
        this.ost_j.clear();
        this.jobs_ost.clear();
    }

    @Override
    public void resetHandler(DefaultSimQueueState queueState) {
        if (queueState == null || queueState != this.queueState) {
            throw new IllegalArgumentException();
        }
        this.ost_j.clear();
        this.jobs_ost.clear();
    }

    public final boolean isEmpty() {
        return this.ost_j.isEmpty();
    }

    public final int getNumberOfOstGroups() {
        return this.jobs_ost.size();
    }

    public final double getObtainedServiceTime(SimJob job) {
        if (job == null || !this.ost_j.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        return this.ost_j.get(job);
    }

    public final double getMinimumObtainedServiceTime() {
        return (Double)this.jobs_ost.firstKey();
    }

    public final double getNextHigherThanMinimumObtainedServiceTime() {
        if (this.getNumberOfOstGroups() < 2) {
            throw new NoSuchElementException();
        }
        return this.jobs_ost.higherKey((Double)this.jobs_ost.firstKey());
    }

    public final double getMaximumObtainedServiceTime() {
        return (Double)this.jobs_ost.lastKey();
    }

    public final double getNextLowerThanMaximumObtainedServiceTime() {
        if (this.getNumberOfOstGroups() < 2) {
            throw new NoSuchElementException();
        }
        return this.jobs_ost.lowerKey((Double)this.jobs_ost.lastKey());
    }

    public final void addStartingJob(SimJob job) {
        if (job == null || this.ost_j.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.ost_j.put(job, 0.0);
        if (!this.jobs_ost.containsKey(0.0)) {
            this.jobs_ost.put(0.0, new LinkedHashSet());
        }
        ((Set)this.jobs_ost.get(0.0)).add(job);
    }

    public final void addStartingJobs(Set<SimJob> jobs) {
        if (jobs == null) {
            throw new IllegalArgumentException();
        }
        for (SimJob job : jobs) {
            this.addStartingJob(job);
        }
    }

    public final void removeJob(SimJob job, boolean mustBePresent) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (mustBePresent && !this.ost_j.containsKey(job)) {
            throw new IllegalStateException();
        }
        this.ost_j.remove(job);
        Iterator jobs_ost_i = this.jobs_ost.entrySet().iterator();
        while (jobs_ost_i.hasNext()) {
            Map.Entry entry = jobs_ost_i.next();
            Set jobs = (Set)entry.getValue();
            if (!jobs.contains(job)) continue;
            jobs.remove(job);
            if (jobs.isEmpty()) {
                jobs_ost_i.remove();
            }
            return;
        }
        if (mustBePresent) {
            throw new IllegalStateException();
        }
    }

    public final void increaseMinimumObtainedServiceTime(double time, double delta_ost, boolean mayOvertake, double TOLERANCE) {
        if (delta_ost < 0.0) {
            throw new IllegalArgumentException();
        }
        if (this.jobs_ost.isEmpty()) {
            throw new IllegalStateException();
        }
        if (delta_ost == 0.0) {
            return;
        }
        double minOst = (Double)this.jobs_ost.firstKey();
        double newOst = minOst + delta_ost;
        if (mayOvertake || this.jobs_ost.size() == 1) {
            for (SimJob job : this.jobs_ost.firstEntry().getValue()) {
                this.ost_j.put(job, newOst);
            }
            Set jobsMinOst = (Set)this.jobs_ost.remove(minOst);
            if (!this.jobs_ost.containsKey(newOst)) {
                this.jobs_ost.put(newOst, jobsMinOst);
            } else {
                ((Set)this.jobs_ost.get(newOst)).addAll(jobsMinOst);
            }
        } else {
            if (newOst > this.jobs_ost.higherKey(minOst) + TOLERANCE) {
                throw new IllegalArgumentException();
            }
            if (newOst >= this.jobs_ost.higherKey(minOst) - TOLERANCE) {
                double newMinOst = Math.max(newOst, this.jobs_ost.higherKey(minOst));
                Set jobsMinOst = (Set)this.jobs_ost.remove(this.jobs_ost.higherKey(minOst));
                jobsMinOst.addAll((Collection)this.jobs_ost.remove(this.jobs_ost.firstKey()));
                this.jobs_ost.put(newMinOst, jobsMinOst);
                for (SimJob job : jobsMinOst) {
                    this.ost_j.put(job, newMinOst);
                }
            } else {
                this.increaseMinimumObtainedServiceTime(time, delta_ost, true, TOLERANCE);
            }
        }
    }

    public final Set<SimJob> getJobsWithObtainedServiceTime(double ost) {
        if (!this.jobs_ost.containsKey(ost)) {
            throw new IllegalArgumentException();
        }
        return (Set)this.jobs_ost.get(ost);
    }

    public final Set<SimJob> getJobsWithMinimumObtainedServiceTime() {
        return this.jobs_ost.firstEntry().getValue();
    }

    public final Set<SimJob> getJobsWithMaximumObtainedServiceTime() {
        return this.jobs_ost.lastEntry().getValue();
    }
}

