/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.qos;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.qos.PQ;
import org.javades.jqueues.r5.extensions.qos.SimQueueQoSStateHandler;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.queues.SimQueuePredictor_Preemptive;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_PQ<J extends SimJob, Q extends PQ, P extends Comparable>
extends SimQueuePredictor_Preemptive<Q> {
    public String toString() {
        return "Predictor[PQ[?]]";
    }

    @Override
    public boolean isStartArmed(Q queue, SimQueueState<SimJob, Q> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        return queueState.getJobsInServiceArea().isEmpty();
    }

    @Override
    public SimQueueState<SimJob, Q> createQueueState(Q queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        queueState.registerHandler(new SimQueueQoSStateHandler(true));
        return queueState;
    }

    protected J getJobToExecute(Q queue, SimQueueState<SimJob, Q> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (queueState.getJobs().isEmpty() || queueState.getServerAccessCredits() == 0 && queueState.getJobsInServiceArea().isEmpty()) {
            return null;
        }
        SimQueueQoSStateHandler queueStateHandler = (SimQueueQoSStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueQoSHandler");
        queueStateHandler.updateJobsQoSMap();
        for (Set jobsP : queueStateHandler.getJobsQoSMap().values()) {
            if (jobsP == null || jobsP.isEmpty()) {
                throw new IllegalStateException();
            }
            for (SimJob job : jobsP) {
                if (!queueState.getJobsInServiceArea().contains(job) && queueState.getServerAccessCredits() <= 0) continue;
                return (J)job;
            }
        }
        throw new IllegalStateException();
    }

    protected J getJobExecuting(Q queue, SimQueueState<SimJob, Q> queueState) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (queueState.getJobsInServiceArea().isEmpty()) {
            return null;
        }
        SimQueueQoSStateHandler queueStateHandler = (SimQueueQoSStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueQoSHandler");
        queueStateHandler.updateJobsQoSMap();
        for (Set jobsP : queueStateHandler.getJobsQoSMap().values()) {
            if (jobsP == null || jobsP.isEmpty()) {
                throw new IllegalStateException();
            }
            for (SimJob job : jobsP) {
                if (!queueState.getJobsInServiceArea().contains(job)) continue;
                return (J)job;
            }
        }
        throw new IllegalStateException();
    }

    protected void reschedule(Q queue, SimQueueState<SimJob, Q> queueState, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        J jobToExecute = this.getJobToExecute(queue, queueState);
        J jobExecuting = this.getJobExecuting(queue, queueState);
        while (jobExecuting != jobToExecute) {
            if (jobExecuting != null) {
                this.preemptJob(queue, queueState, (SimJob)jobExecuting, visitLogsSet);
            }
            if (jobToExecute != null && !queueState.getJobsInServiceArea().contains(jobToExecute)) {
                double remainingServiceTime;
                HashSet<J> starters = new HashSet<J>();
                starters.add(jobToExecute);
                queueState.doStarts(time, starters);
                if (queueState.getJobs().contains(jobToExecute) && (remainingServiceTime = queueState.getJobRemainingServiceTimeMap().get(jobToExecute).doubleValue()) == 0.0) {
                    queueState.doExits(time, null, null, starters, null, visitLogsSet);
                }
            }
            jobToExecute = this.getJobToExecute(queue, queueState);
            jobExecuting = this.getJobExecuting(queue, queueState);
        }
    }

    @Override
    public double getNextQueueEventTimeBeyond(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        double time = queueState.getTime();
        if (queueState.getRemainingServiceMap().isEmpty()) {
            return Double.NaN;
        }
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        J executingJob = this.getJobExecuting(queue, queueState);
        double rs = queueState.getJobRemainingServiceTimeMap().get(executingJob);
        if (rs < 0.0) {
            throw new RuntimeException();
        }
        if (Double.isFinite(rs)) {
            queueEventTypes.add(SimQueueSimpleEventType.DEPARTURE);
            return time + rs;
        }
        return Double.NaN;
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(Q queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                queueState.doArrivals(time, arrivals, visitLogsSet);
                if (!queueState.isQueueAccessVacation() && queueState.getServerAccessCredits() >= 1) {
                    this.reschedule(queue, queueState, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                boolean interruptService;
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job) && ((interruptService = ((Boolean)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).get(job)).booleanValue()) || !queueState.getJobsInServiceArea().contains(job))) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                    this.reschedule(queue, queueState, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int oldSac = queueState.getServerAccessCredits();
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
                if (oldSac == 0 && newSac > 0 && !queueState.getJobsInWaitingArea().isEmpty()) {
                    this.reschedule(queue, queueState, visitLogsSet);
                }
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(Q queue, SimQueueState<SimJob, Q> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, Q>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.DEPARTURE) {
                HashSet<J> departures = new HashSet<J>();
                J departingJob = this.getJobExecuting(queue, queueState);
                departures.add(departingJob);
                queueState.doExits(time, null, null, departures, null, visitLogsSet);
                this.reschedule(queue, queueState, visitLogsSet);
            } else {
                throw new RuntimeException();
            }
        }
        queueEventTypes.remove(eventType);
    }

    @Override
    public void updateToTime(Q queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        double oldTime = queueState.getTime();
        if (!Double.isNaN(oldTime)) {
            double dT = newTime - oldTime;
            if (dT < 0.0) {
                throw new RuntimeException();
            }
            Map rsTimeMap = queueState.getJobRemainingServiceTimeMap();
            NavigableMap rsMap = queueState.getRemainingServiceMap();
            if (dT > 0.0 && !rsTimeMap.isEmpty()) {
                J executingJob = this.getJobExecuting(queue, queueState);
                double dS = dT;
                double oldRs = rsTimeMap.get(executingJob);
                double newRs = oldRs - dS;
                rsTimeMap.put(executingJob, newRs);
                if (!rsMap.containsKey(oldRs)) {
                    throw new IllegalStateException();
                }
                if (((List)rsMap.get(oldRs)).size() == 1) {
                    rsMap.put(newRs, rsMap.get(oldRs));
                    rsMap.remove(oldRs);
                } else {
                    ((List)rsMap.get(oldRs)).remove(0);
                    rsMap.put(newRs, new ArrayList());
                    ((List)rsMap.get(newRs)).add(executingJob);
                }
            }
        }
        queueState.setTime(newTime);
    }
}

