/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.qos;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.extensions.qos.SimQueueQoS;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueStateHandler;

public final class SimQueueQoSStateHandler<J extends SimJob, Q extends SimQueueQoS, P>
implements SimQueueStateHandler {
    private DefaultSimQueueState<J, Q> queueState = null;
    private final Map<P, Set<J>> jobsQoSMap;

    public SimQueueQoSStateHandler(boolean comparableQoS) {
        this.jobsQoSMap = comparableQoS ? new TreeMap<P, Set<J>>() : new HashMap<P, Set<J>>();
    }

    @Override
    public final String getHandlerName() {
        return "SimQueueQoSHandler";
    }

    @Override
    public final void initHandler(DefaultSimQueueState queueState) {
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        if (this.queueState != null) {
            throw new IllegalStateException();
        }
        this.queueState = queueState;
        this.jobsQoSMap.clear();
    }

    @Override
    public void resetHandler(DefaultSimQueueState queueState) {
        if (queueState == null || queueState != this.queueState) {
            throw new IllegalArgumentException();
        }
        this.jobsQoSMap.clear();
    }

    public final Map<P, Set<J>> getJobsQoSMap() {
        return this.jobsQoSMap;
    }

    public void updateJobsQoSMap() {
        Iterator<Map.Entry<P, Set<J>>> entryIterator = this.jobsQoSMap.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Set<J> jobs = entryIterator.next().getValue();
            if (jobs == null || jobs.isEmpty()) {
                throw new IllegalStateException();
            }
            Iterator<J> jobIterator = jobs.iterator();
            while (jobIterator.hasNext()) {
                if (this.queueState.getJobs().contains(jobIterator.next())) continue;
                jobIterator.remove();
            }
            if (!jobs.isEmpty()) continue;
            entryIterator.remove();
        }
        Object defaultQoS = ((SimQueueQoS)this.queueState.getQueue()).getDefaultJobQoS();
        if (defaultQoS == null) {
            throw new IllegalStateException();
        }
        for (SimJob job : this.queueState.getJobs()) {
            Object qos;
            Object object = qos = job.getQoS() == null ? defaultQoS : job.getQoS();
            if (!this.jobsQoSMap.containsKey(qos)) {
                this.jobsQoSMap.put(qos, new LinkedHashSet());
            }
            if (this.jobsQoSMap.get(qos).contains(job)) continue;
            this.jobsQoSMap.get(qos).add(job);
        }
    }
}

