/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.extensions.visitscounter;

import java.util.HashMap;
import java.util.Map;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueStateHandler;

public final class SimQueueVisitsCounterStateHandler
implements SimQueueStateHandler {
    private DefaultSimQueueState queueState = null;
    private int totalNumberOfVisits = 0;
    private final Map<SimJob, Integer> numberOfVisitsPerJob = new HashMap<SimJob, Integer>();

    @Override
    public final String getHandlerName() {
        return "SimQueueVisitsCounterStateHandler";
    }

    @Override
    public final void initHandler(DefaultSimQueueState queueState) {
        if (queueState == null) {
            throw new IllegalArgumentException();
        }
        if (this.queueState != null) {
            throw new IllegalStateException();
        }
        this.queueState = queueState;
        this.totalNumberOfVisits = 0;
        this.numberOfVisitsPerJob.clear();
    }

    @Override
    public void resetHandler(DefaultSimQueueState queueState) {
        if (queueState == null || queueState != this.queueState) {
            throw new IllegalArgumentException();
        }
        this.totalNumberOfVisits = 0;
        this.numberOfVisitsPerJob.clear();
    }

    public final int getTotalNumberOfVisits() {
        return this.totalNumberOfVisits;
    }

    public final void incTotalNumberOfVisits() {
        ++this.totalNumberOfVisits;
    }

    public final void resetTotalNumberOfVisits() {
        this.totalNumberOfVisits = 0;
    }

    public final int getNumberOfVisitsForJob(SimJob job) {
        if (job == null || !this.numberOfVisitsPerJob.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        return this.numberOfVisitsPerJob.get(job);
    }

    public final boolean containsJob(SimJob job) {
        return this.numberOfVisitsPerJob.containsKey(job);
    }

    public final void newJob(SimJob job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (this.numberOfVisitsPerJob.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.numberOfVisitsPerJob.put(job, 1);
    }

    public final void incNumberOfVisitsForJob(SimJob job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.numberOfVisitsPerJob.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.numberOfVisitsPerJob.put(job, this.numberOfVisitsPerJob.get(job) + 1);
    }

    public final void removeJob(SimJob job) {
        if (job == null) {
            throw new IllegalArgumentException();
        }
        if (!this.numberOfVisitsPerJob.containsKey(job)) {
            throw new IllegalArgumentException();
        }
        this.numberOfVisitsPerJob.remove(job);
    }
}

