/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.listener;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.listener.DefaultSimQueueListener;

public final class MultiSimQueueNotificationProcessor<J extends SimJob, Q extends SimQueue>
extends DefaultSimQueueListener<J, Q> {
    private final List<Q> queues;
    final List<Notification<J, Q>> notifications = new ArrayList<Notification<J, Q>>();
    private Processor processor = null;
    private boolean processing = false;

    public MultiSimQueueNotificationProcessor(Set<Q> queues) {
        if (queues == null || queues.contains(null)) {
            throw new IllegalArgumentException();
        }
        this.queues = new ArrayList<Q>(queues);
        for (SimQueue queue : queues) {
            queue.registerSimEntityListener(this);
        }
    }

    public final void setProcessor(Processor processor) {
        if (this.processing) {
            throw new IllegalStateException();
        }
        this.processor = processor;
    }

    @Override
    public final void notifyStateChanged(double time, SimEntity entity, List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> notifications) {
        if (entity == null || !(entity instanceof SimQueue)) {
            throw new IllegalArgumentException("Null entity or entity that is not a queue: " + entity + ".");
        }
        if (!this.queues.contains((SimQueue)entity)) {
            throw new IllegalArgumentException("Queue supplied is not a sub-queue: " + entity + ".");
        }
        if (notifications == null || notifications.isEmpty()) {
            throw new IllegalArgumentException("Null or empty notifications: " + notifications + ".");
        }
        for (Map map : notifications) {
            if (map != null && map.size() == 1 && !map.containsKey(null)) continue;
            throw new IllegalArgumentException();
        }
        this.notifications.add(new Notification(time, (SimQueue)entity, "" + this.queues.indexOf((SimQueue)entity), notifications));
        entity.doAfterNotifications(this::afterNotificationsTrigger);
    }

    protected final void afterNotificationsTrigger() {
        if (!this.processing && this.processor != null && !this.notifications.isEmpty()) {
            this.processing = true;
            this.processor.process(this.notifications);
            this.notifications.clear();
            this.processing = false;
        }
    }

    public static <J extends SimJob, Q extends SimQueue> boolean contains(List<Notification<J, Q>> notifications, SimEntitySimpleEventType.Member eventType) {
        if (eventType == null) {
            throw new IllegalArgumentException();
        }
        if (notifications == null || notifications.isEmpty()) {
            return false;
        }
        for (Notification<J, Q> notification : notifications) {
            for (Map<SimEntitySimpleEventType.Member, SimJQEvent<J, Q>> subNotification : notification.getSubNotifications()) {
                if (subNotification.keySet().iterator().next() != eventType) continue;
                return true;
            }
        }
        return false;
    }

    public static <J extends SimJob, Q extends SimQueue> void compact(List<Notification<J, Q>> notifications) {
        if (notifications == null || notifications.isEmpty()) {
            return;
        }
        Iterator<Notification<J, Q>> i_notifications = notifications.iterator();
        while (i_notifications.hasNext()) {
            Notification<J, Q> notification = i_notifications.next();
            if (notification != null && !notification.getSubNotifications().isEmpty()) continue;
            i_notifications.remove();
        }
    }

    @FunctionalInterface
    public static interface Processor<J extends SimJob, Q extends SimQueue> {
        public void process(List<Notification<J, Q>> var1);
    }

    public static final class Notification<J extends SimJob, Q extends SimQueue> {
        private final double time;
        private final Q queue;
        private final String queueAnnotation;
        private final List<Map<SimEntitySimpleEventType.Member, SimJQEvent<J, Q>>> subNotifications;

        public final double getTime() {
            return this.time;
        }

        public final Q getQueue() {
            return this.queue;
        }

        public final List<Map<SimEntitySimpleEventType.Member, SimJQEvent<J, Q>>> getSubNotifications() {
            return this.subNotifications;
        }

        protected Notification(double time, Q queue, String queueAnnotation, List<Map<SimEntitySimpleEventType.Member, SimJQEvent<J, Q>>> subNotifications) {
            if (queue == null || subNotifications == null) {
                throw new IllegalArgumentException();
            }
            this.time = time;
            this.queue = queue;
            this.queueAnnotation = queueAnnotation;
            this.subNotifications = new ArrayList<Map<SimEntitySimpleEventType.Member, SimJQEvent<J, Q>>>(subNotifications);
        }

        public final String toString() {
            if (this.queueAnnotation != null) {
                return "@" + this.queue + "[" + this.queueAnnotation + "]: " + this.subNotifications;
            }
            return "@" + this.queue + this.subNotifications;
        }
    }
}

