/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.listener.DefaultSimQueueListener;

public class SimQueueAccessVacationLogger
extends DefaultSimQueueListener {
    private final List<Map<Double, Boolean>> qavLog = new ArrayList<Map<Double, Boolean>>();

    public final List<Map<Double, Boolean>> getQueueAccessVacationLog() {
        return Collections.unmodifiableList(this.qavLog);
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        this.qavLog.clear();
    }

    @Override
    public void notifyStartQueueAccessVacation(double time, SimQueue queue) {
        this.qavLog.add(Collections.singletonMap(time, true));
    }

    @Override
    public void notifyStopQueueAccessVacation(double time, SimQueue queue) {
        this.qavLog.add(Collections.singletonMap(time, false));
    }

    public static boolean matchQueueAccessVacationLogs(List<Map<Double, Boolean>> predictedQavLogs, List<Map<Double, Boolean>> actualQavLogs, double accuracy, String testString) {
        if (predictedQavLogs == null || actualQavLogs == null) {
            throw new IllegalArgumentException();
        }
        boolean retVal = true;
        if (predictedQavLogs.size() != actualQavLogs.size()) {
            retVal = false;
        } else {
            for (int i = 0; i < predictedQavLogs.size(); ++i) {
                if (predictedQavLogs.get(i).size() != 1 || actualQavLogs.get(i).size() != 1) {
                    throw new IllegalArgumentException();
                }
                if (Math.abs(predictedQavLogs.get(i).keySet().iterator().next() - actualQavLogs.get(i).keySet().iterator().next()) > accuracy) {
                    retVal = false;
                    break;
                }
                if (predictedQavLogs.get(i).values().iterator().next().equals(actualQavLogs.get(i).values().iterator().next())) continue;
                retVal = false;
                break;
            }
        }
        if (!retVal) {
            System.err.println("Queue-Access Vacation Logs mismatch!");
            if (testString != null) {
                System.err.println("  Test:");
                System.err.println(testString);
            }
            System.err.println("  Predicted: " + predictedQavLogs + ".");
            System.err.println("  Actual   : " + actualQavLogs + ".");
        }
        return retVal;
    }
}

