/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.listener.DefaultSimQueueListener;

public class SimQueueServerAccessCreditsAvailabilityLogger
extends DefaultSimQueueListener {
    private final List<Map<Double, Boolean>> sacLog = new ArrayList<Map<Double, Boolean>>();

    public final List<Map<Double, Boolean>> getServerAccessCreditsAvailabilityLog() {
        return Collections.unmodifiableList(this.sacLog);
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        this.sacLog.clear();
    }

    @Override
    public void notifyRegainedServerAccessCredits(double time, SimQueue queue) {
        this.sacLog.add(Collections.singletonMap(time, true));
    }

    @Override
    public void notifyOutOfServerAccessCredits(double time, SimQueue queue) {
        this.sacLog.add(Collections.singletonMap(time, false));
    }

    public static boolean matchServerAccessCreditsAvailabilityLogs(List<Map<Double, Boolean>> predictedSacLogs, List<Map<Double, Boolean>> actualSacLogs, double accuracy, String testString) {
        if (predictedSacLogs == null || actualSacLogs == null) {
            throw new IllegalArgumentException();
        }
        boolean retVal = true;
        if (predictedSacLogs.size() != actualSacLogs.size()) {
            retVal = false;
        } else {
            for (int i = 0; i < predictedSacLogs.size(); ++i) {
                if (predictedSacLogs.get(i).size() != 1 || actualSacLogs.get(i).size() != 1) {
                    throw new IllegalArgumentException();
                }
                if (Math.abs(predictedSacLogs.get(i).keySet().iterator().next() - actualSacLogs.get(i).keySet().iterator().next()) > accuracy) {
                    retVal = false;
                    break;
                }
                if (predictedSacLogs.get(i).values().iterator().next().equals(actualSacLogs.get(i).values().iterator().next())) continue;
                retVal = false;
                break;
            }
        }
        if (!retVal) {
            System.err.println("Server-Access Credits Availability Logs mismatch!");
            if (testString != null) {
                System.err.println("  Test:");
                System.err.println(testString);
            }
            System.err.println("  Predicted: " + predictedSacLogs + ".");
            System.err.println("  Actual   : " + actualSacLogs + ".");
        }
        return retVal;
    }
}

