/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.listener;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.listener.DefaultSimQueueListener;

public class SimQueueStartArmedLogger
extends DefaultSimQueueListener {
    private final List<Map<Double, Boolean>> staLog = new ArrayList<Map<Double, Boolean>>();

    public final List<Map<Double, Boolean>> getStartArmedLog() {
        return Collections.unmodifiableList(this.staLog);
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        this.staLog.clear();
    }

    @Override
    public void notifyNewStartArmed(double time, SimQueue queue, boolean startArmed) {
        this.staLog.add(Collections.singletonMap(time, startArmed));
    }

    public static boolean matchStartArmedLogs(List<Map<Double, Boolean>> predictedStaLogs, List<Map<Double, Boolean>> actualStaLogs, double accuracy, String testString) {
        if (predictedStaLogs == null || actualStaLogs == null) {
            throw new IllegalArgumentException();
        }
        boolean retVal = true;
        if (predictedStaLogs.size() != actualStaLogs.size()) {
            retVal = false;
        } else {
            for (int i = 0; i < predictedStaLogs.size(); ++i) {
                if (predictedStaLogs.get(i).size() != 1 || actualStaLogs.get(i).size() != 1) {
                    throw new IllegalArgumentException();
                }
                if (Math.abs(predictedStaLogs.get(i).keySet().iterator().next() - actualStaLogs.get(i).keySet().iterator().next()) > accuracy) {
                    retVal = false;
                    break;
                }
                if (predictedStaLogs.get(i).values().iterator().next().equals(actualStaLogs.get(i).values().iterator().next())) continue;
                retVal = false;
                break;
            }
        }
        if (!retVal && SimQueueStartArmedLogger.compactStartArmedLogs(predictedStaLogs)) {
            System.err.println("Predictor StartArmed Logs Compaction; check predictor!");
            return SimQueueStartArmedLogger.matchStartArmedLogs(predictedStaLogs, actualStaLogs, accuracy, testString);
        }
        if (!retVal) {
            System.err.println("StartArmed Logs mismatch!");
            if (testString != null) {
                System.err.println("  Test:");
                System.err.println(testString);
            }
            System.err.println("  Predicted: " + predictedStaLogs + ".");
            System.err.println("  Actual   : " + actualStaLogs + ".");
        }
        return retVal;
    }

    private static boolean compactStartArmedLogs(List<Map<Double, Boolean>> staLogs) {
        if (staLogs == null) {
            throw new IllegalArgumentException();
        }
        if (staLogs.size() == 1) {
            return false;
        }
        boolean changed = false;
        boolean changing = true;
        block0: while (changing) {
            changing = false;
            for (int i = 0; i < staLogs.size() - 1; ++i) {
                double time_ip1;
                double time_i = staLogs.get(i).keySet().iterator().next();
                if (time_i != (time_ip1 = staLogs.get(i + 1).keySet().iterator().next().doubleValue())) continue;
                boolean sta_i = staLogs.get(i).get(time_i);
                boolean sta_ip1 = staLogs.get(i + 1).get(time_ip1);
                if (sta_ip1 == sta_i) {
                    staLogs.remove(i + 1);
                } else {
                    staLogs.remove(i + 1);
                    staLogs.remove(i);
                }
                changed = true;
                changing = true;
                continue block0;
            }
        }
        return changed;
    }
}

