/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.listener;

import java.util.List;
import java.util.Map;
import org.javades.jqueues.r5.entity.SimEntity;
import org.javades.jqueues.r5.entity.SimEntityEvent;
import org.javades.jqueues.r5.entity.SimEntityListener;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;

public class StdOutSimEntityListener
implements SimEntityListener {
    protected String getHeaderString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void notifyResetEntity(SimEntity entity) {
        System.out.print(this.getHeaderString() + " ");
        System.out.println("entity=" + entity + ": RESET.");
    }

    @Override
    public void notifyUpdate(double time, SimEntity entity) {
        System.out.print(this.getHeaderString() + " ");
        System.out.println("t=" + time + ", entity=" + entity + ": UPDATE.");
    }

    @Override
    public void notifyStateChanged(double time, SimEntity entity, List<Map<SimEntitySimpleEventType.Member, SimEntityEvent>> notifications) {
        System.out.print(this.getHeaderString() + " ");
        System.out.print("t=" + time + ", entity=" + entity + ": STATE CHANGED:");
        if (notifications == null) {
            System.out.println(" === null ====");
        } else {
            System.out.println("");
            for (Map<SimEntitySimpleEventType.Member, SimEntityEvent> notification : notifications) {
                if (notification == null) {
                    System.out.println("  => null");
                    continue;
                }
                System.out.println("  => " + notification.keySet().iterator().next() + " [" + (Object)((Object)notification.values().iterator().next()) + "]");
            }
        }
    }
}

