/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.SimQueueSelector;
import org.javades.jqueues.r5.entity.jq.queue.composite.feedback.FB_p;
import org.javades.jqueues.r5.entity.jq.queue.composite.feedback.FB_v;
import org.javades.jqueues.r5.entity.jq.queue.composite.jackson.Jackson;
import org.javades.jqueues.r5.entity.jq.queue.composite.parallel.Par;
import org.javades.jqueues.r5.entity.jq.queue.composite.tandem.Tandem;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.AbstractNonPreemptiveWorkConservingSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.RANDOM;
import org.javades.jqueues.r5.listener.StdOutSimQueueListener;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventList;

public final class CompositeExample {
    private CompositeExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR (some) for composite queues...");
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(true, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(DefaultSimEvent.class);
        System.out.println("-> Creating FCFS queue...");
        FCFS fcfsQueue = new FCFS((SimEventList)el);
        fcfsQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating LCFS queue...");
        LCFS lcfsQueue = new LCFS((SimEventList)el);
        lcfsQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating Tandem queue...");
        LinkedHashSet<AbstractNonPreemptiveWorkConservingSimQueue> set = new LinkedHashSet<AbstractNonPreemptiveWorkConservingSimQueue>();
        set.add(fcfsQueue);
        set.add(lcfsQueue);
        DelegateSimJobFactory<TestDelegateSimJob, SimQueue, DefaultExampleSimJob, SimQueue> delegateSimJobFactory = new DelegateSimJobFactory<TestDelegateSimJob, SimQueue, DefaultExampleSimJob, SimQueue>(){

            @Override
            public TestDelegateSimJob newInstance(double time, DefaultExampleSimJob job, SimQueue queue) {
                return new TestDelegateSimJob(job, true);
            }
        };
        final Tandem tandemQueue = new Tandem((SimEventList)el, set, delegateSimJobFactory);
        tandemQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Submitting jobs to Tandem queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    tandemQueue.arrive(arrTime, j);
                }
            }));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating FCFS queue...");
        final FCFS fcfsQueue2 = new FCFS((SimEventList)el);
        fcfsQueue2.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating LCFS queue...");
        final LCFS lcfsQueue2 = new LCFS((SimEventList)el);
        lcfsQueue2.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating Parallel queue...");
        LinkedHashSet<AbstractNonPreemptiveWorkConservingSimQueue> set2 = new LinkedHashSet<AbstractNonPreemptiveWorkConservingSimQueue>();
        set2.add(fcfsQueue2);
        set2.add(lcfsQueue2);
        final Par parallelQueue = new Par((SimEventList)el, set2, (SimQueueSelector)new SimQueueSelector<SimJob, SimQueue>(){
            boolean toSecond = false;

            @Override
            public void resetSimQueueSelector() {
            }

            @Override
            public SimQueue selectFirstQueue(double time, SimJob job) {
                SimQueue dstQueue = this.toSecond ? lcfsQueue2 : fcfsQueue2;
                this.toSecond = !this.toSecond;
                return dstQueue;
            }

            @Override
            public SimQueue<SimJob, SimQueue> selectNextQueue(double time, SimJob job, SimQueue previousQueue) {
                return null;
            }
        }, (DelegateSimJobFactory)delegateSimJobFactory);
        parallelQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Submitting jobs to Parallel queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    parallelQueue.arrive(arrTime, j);
                }
            }));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating FCFS queue...");
        FCFS fcfsQueue3 = new FCFS((SimEventList)el);
        fcfsQueue3.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating NumVisits feedback queue (5 visits)...");
        final FB_v numVisitsFBQueue = new FB_v((SimEventList)el, fcfsQueue3, 5, (DelegateSimJobFactory)delegateSimJobFactory);
        numVisitsFBQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Submitting jobs to NumVisitsFB queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    numVisitsFBQueue.arrive(arrTime, j);
                }
            }));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating RANDOM queue...");
        RANDOM randomQueue = new RANDOM((SimEventList)el);
        randomQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Creating probabilistic feedback queue (p=50%)...");
        final FB_p pFBQueue = new FB_p((SimEventList)el, randomQueue, 0.5, null, delegateSimJobFactory);
        pFBQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Submitting jobs to probabilistic feedback queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    pFBQueue.arrive(arrTime, j);
                }
            }));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating 4 FCFS queues and putting them into a LinkedHashSet...");
        FCFS jFcfsQueue1 = new FCFS((SimEventList)el);
        jFcfsQueue1.setName(jFcfsQueue1.toStringDefault() + "1");
        jFcfsQueue1.registerSimEntityListener(new StdOutSimQueueListener());
        FCFS jFcfsQueue2 = new FCFS((SimEventList)el);
        jFcfsQueue2.setName(jFcfsQueue2.toStringDefault() + "2");
        jFcfsQueue2.registerSimEntityListener(new StdOutSimQueueListener());
        FCFS jFcfsQueue3 = new FCFS((SimEventList)el);
        jFcfsQueue3.setName(jFcfsQueue3.toStringDefault() + "3");
        jFcfsQueue3.registerSimEntityListener(new StdOutSimQueueListener());
        FCFS jFcfsQueue4 = new FCFS((SimEventList)el);
        jFcfsQueue3.setName(jFcfsQueue4.toStringDefault() + "4");
        jFcfsQueue4.registerSimEntityListener(new StdOutSimQueueListener());
        LinkedHashSet jacksonQueues = new LinkedHashSet();
        jacksonQueues.add(jFcfsQueue1);
        jacksonQueues.add(jFcfsQueue2);
        jacksonQueues.add(jFcfsQueue3);
        jacksonQueues.add(jFcfsQueue4);
        System.out.println("-> Creating Arrival and Transition probabilities...");
        double[] pdfArrival = new double[]{0.4, 0.4, 0.0, 0.0};
        double[][] pdfTransition = new double[][]{{0.2, 0.2, 0.2, 0.2}, {0.2, 0.2, 0.2, 0.2}, {0.0, 0.0, 0.4, 0.4}, {0.0, 0.0, 0.4, 0.4}};
        System.out.println("-> Creating Jackson queueing network...");
        final Jackson jacksonQueue = new Jackson((SimEventList)el, jacksonQueues, pdfArrival, pdfTransition, null, delegateSimJobFactory);
        jacksonQueue.registerSimEntityListener(new StdOutSimQueueListener());
        System.out.println("-> Submitting jobs to Jackson queueing network...");
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    jacksonQueue.arrive(arrTime, j);
                }
            }));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("=== FINISHED ===");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TestDelegateSimJob
    extends AbstractSimJob {
        private final boolean reported;
        private final int n;

        public TestDelegateSimJob(DefaultExampleSimJob realSimJob, boolean reported) {
            super(null, null);
            this.reported = reported;
            this.n = realSimJob.n;
            if (this.n < 0) {
                throw new IllegalArgumentException();
            }
            this.setName("DJ_" + this.n);
        }

        @Override
        public double getServiceTime(SimQueue queue) throws IllegalArgumentException {
            if (queue instanceof LCFS) {
                return 2 * this.n;
            }
            if (queue instanceof FCFS) {
                return this.n;
            }
            if (queue instanceof RANDOM) {
                return this.n;
            }
            throw new IllegalStateException();
        }
    }
}

