/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncJL;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.RANDOM;
import org.javades.jqueues.r5.listener.StdOutSimQueueListener;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;

public final class EncJLExample {
    private EncJLExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR  EncJL ===");
        System.out.println();
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(false, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(DefaultSimEvent.class);
        System.out.println("-> Creating IS queue...");
        IS isQueue = new IS((SimEventList)el);
        System.out.println("-> Creating EncJL...");
        DelegateSimJobFactory delegateSimJobFactory = (time, job, queue) -> new TestDelegateSimJob((DefaultExampleSimJob)job, false);
        EncJL encjlQueue = new EncJL((SimEventList)el, isQueue, delegateSimJobFactory, 1, 1, 2);
        StdOutSimQueueListener encListener = new StdOutSimQueueListener();
        encListener.setOnlyResetsAndUpdatesAndStateChanges(true);
        encjlQueue.registerSimEntityListener(encListener);
        System.out.println("-> Submitting jobs to EncJL...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            j.resetEntity();
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> encjlQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        System.out.println("=== FINISHED ===");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TestDelegateSimJob
    extends AbstractSimJob {
        private final boolean reported;
        private final int n;

        public TestDelegateSimJob(DefaultExampleSimJob realSimJob, boolean reported) {
            super(null, null);
            this.reported = reported;
            this.n = realSimJob.n;
            if (this.n < 0) {
                throw new IllegalArgumentException();
            }
            this.setName("DJ_" + this.n);
        }

        @Override
        public double getServiceTime(SimQueue queue) throws IllegalArgumentException {
            if (queue instanceof LCFS) {
                return 2 * this.n;
            }
            if (queue instanceof FCFS) {
                return this.n;
            }
            if (queue instanceof RANDOM) {
                return this.n;
            }
            if (queue instanceof IS) {
                return (double)this.n + 0.05;
            }
            throw new IllegalStateException();
        }
    }
}

