/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.DelegateSimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.composite.enc.EncTL;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.RANDOM;
import org.javades.jqueues.r5.listener.StdOutSimQueueListener;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;

public final class EncTLExample {
    private EncTLExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR  EncTL ===");
        System.out.println();
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(false, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(DefaultSimEvent.class);
        System.out.println("-> Creating FCFS queue...");
        FCFS fcfsQueue = new FCFS((SimEventList)el);
        System.out.println("-> Creating EncTL...");
        DelegateSimJobFactory delegateSimJobFactory = (time, job, queue) -> new TestDelegateSimJob((DefaultExampleSimJob)job, false);
        EncTL enctlQueue = new EncTL((SimEventList)el, fcfsQueue, delegateSimJobFactory, 20.1, 5.2, 21.3);
        StdOutSimQueueListener encListener = new StdOutSimQueueListener();
        encListener.setOnlyResetsAndUpdatesAndStateChanges(true);
        enctlQueue.registerSimEntityListener(encListener);
        for (EncTL.ExpirationMethod expirationMethod : EncTL.ExpirationMethod.values()) {
            System.out.println();
            System.out.println("=== Setting expiration method to " + (Object)((Object)expirationMethod) + ".");
            System.out.println();
            enctlQueue.setExprirationMethod(expirationMethod);
            System.out.println("-> Submitting jobs to EncTL...");
            for (int i = 0; i < jobList.size(); ++i) {
                SimJob j = (SimJob)jobList.get(i);
                j.resetEntity();
                double arrTime = i + 1;
                el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> enctlQueue.arrive(arrTime, j)));
            }
            System.out.println("-> Executing event list...");
            System.out.println();
            el.run();
            System.out.println();
            System.out.println("-> Resetting event list...");
            el.reset();
        }
        System.out.println();
        System.out.println("=== FINISHED ===");
        try {
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static class TestDelegateSimJob
    extends AbstractSimJob {
        private final boolean reported;
        private final int n;

        public TestDelegateSimJob(DefaultExampleSimJob realSimJob, boolean reported) {
            super(null, null);
            this.reported = reported;
            this.n = realSimJob.n;
            if (this.n < 0) {
                throw new IllegalArgumentException();
            }
            this.setName("DJ_" + this.n);
        }

        @Override
        public double getServiceTime(SimQueue queue) throws IllegalArgumentException {
            if (queue instanceof LCFS) {
                return 2 * this.n;
            }
            if (queue instanceof FCFS) {
                return this.n;
            }
            if (queue instanceof RANDOM) {
                return this.n;
            }
            throw new IllegalStateException();
        }
    }
}

