/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS_B;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS_c;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IC;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS_CST;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LJF;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.NoBuffer_c;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.RANDOM;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.SJF;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.SUR;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;

public final class NonPreemptiveExample {
    private NonPreemptiveExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR nonpreemptive PACKAGE ===");
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(false, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(SimEvent.class);
        System.out.println("-> Creating FCFS queue...");
        FCFS fcfsQueue = new FCFS((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        fcfsQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to FCFS queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> fcfsQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating FCFS_B queue with buffer size 2...");
        FCFS_B fcfs_bQueue = new FCFS_B((SimEventList)el, 2);
        System.out.println("-> Registering queue listener...");
        fcfs_bQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to FCFS_B queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            fcfs_bQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating FCFS_c queue with 3 servers...");
        FCFS_c fcfs_cQueue = new FCFS_c((SimEventList)el, 3);
        System.out.println("-> Registering queue listener...");
        fcfs_cQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to FCFS_c queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            fcfs_cQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating NoBuffer_c queue with 3 servers...");
        NoBuffer_c noBuffer_cQueue = new NoBuffer_c((SimEventList)el, 3);
        System.out.println("-> Registering queue listener...");
        noBuffer_cQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to NoBuffer_c queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            noBuffer_cQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating LCFS queue...");
        LCFS lcfsQueue = new LCFS((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        lcfsQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to LCFS queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            lcfsQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating IS queue...");
        IS isQueue = new IS((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        isQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to IS queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            isQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating IS_CST queue with service time 4...");
        IS_CST is_cstQueue = new IS_CST((SimEventList)el, 4.0);
        System.out.println("-> Registering queue listener...");
        is_cstQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to IS_CST queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            is_cstQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating IC queue...");
        IC icQueue = new IC((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        icQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to IC queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            icQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating RANDOM queue...");
        RANDOM randomQueue = new RANDOM((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        randomQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to RANDOM queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            randomQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SJF queue...");
        SJF sjfQueue = new SJF((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        sjfQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to SJF queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = jobList.size() - i;
            sjfQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        el.reset();
        System.out.println("-> Creating LJF queue...");
        LJF ljfQueue = new LJF((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        ljfQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to LJF queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            ljfQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        el.reset();
        System.out.println("-> Creating SUR queue...");
        SUR surQueue = new SUR((SimEventList)el);
        System.out.println("-> Registering queue listener...");
        surQueue.registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to SUR queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            surQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("=== FINISHED ===");
    }
}

