/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.P_LCFS;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.SRTF;
import org.javades.jqueues.r5.listener.StdOutSimJQListener;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;

public final class PreemptiveExample {
    private PreemptiveExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR preemptive PACKAGE ===");
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(false, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(SimEvent.class);
        System.out.println("-> Creating P_LCFS queue (Preemptive/Drop) and registering System.out listener...");
        P_LCFS p_lcfsQueue_drop = new P_LCFS((SimEventList)el, PreemptionStrategy.DROP);
        p_lcfsQueue_drop.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to P_LCFS (Preemptive/Drop) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> p_lcfsQueue_drop.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating P_LCFS queue (Preemptive/Resume) and registering System.out listener...");
        P_LCFS p_lcfsQueue_resume = new P_LCFS((SimEventList)el, PreemptionStrategy.RESUME);
        p_lcfsQueue_resume.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to P_LCFS (Preemptive/Resume) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> p_lcfsQueue_resume.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating P_LCFS queue (Preemptive/Restart) and registering System.out listener...");
        P_LCFS p_lcfsQueue_restart = new P_LCFS((SimEventList)el, PreemptionStrategy.RESTART);
        p_lcfsQueue_restart.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to P_LCFS (Preemptive/Restart) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> p_lcfsQueue_restart.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating P_LCFS queue (Preemptive/Depart) and registering System.out listener...");
        P_LCFS p_lcfsQueue_depart = new P_LCFS((SimEventList)el, PreemptionStrategy.DEPART);
        p_lcfsQueue_depart.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to P_LCFS (Preemptive/Depart) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> p_lcfsQueue_depart.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SRTF queue (Preemptive/Drop) and registering System.out listener...");
        SRTF srtfQueue_drop = new SRTF((SimEventList)el, PreemptionStrategy.DROP);
        srtfQueue_drop.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to SRTF (Preemptive/Drop) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = (double)jobList.size() - 0.8 * (double)i;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, arrTime, null, event -> srtfQueue_drop.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SRTF queue (Preemptive/Resume) and registering System.out listener...");
        SRTF srtfQueue_resume = new SRTF((SimEventList)el, PreemptionStrategy.RESUME);
        srtfQueue_resume.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to SRTF (Preemptive/Resume) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = (double)jobList.size() - 0.8 * (double)i;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, arrTime, null, event -> srtfQueue_resume.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SRTF queue (Preemptive/Restart) and registering System.out listener...");
        SRTF srtfQueue_restart = new SRTF((SimEventList)el, PreemptionStrategy.RESTART);
        srtfQueue_restart.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to SRTF (Preemptive/Restart) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = (double)jobList.size() - 0.8 * (double)i;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, arrTime, null, event -> srtfQueue_restart.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SRTF queue (Preemptive/Depart) and registering System.out listener...");
        SRTF srtfQueue_depart = new SRTF((SimEventList)el, PreemptionStrategy.DEPART);
        srtfQueue_depart.registerSimEntityListener(new StdOutSimJQListener());
        System.out.println("-> Submitting jobs to SRTF (Preemptive/Depart) queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = (double)jobList.size() - 0.8 * (double)i;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, arrTime, null, event -> srtfQueue_depart.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("=== FINISHED ===");
    }
}

