/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import java.util.Random;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.CUPS;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.PS;
import org.javades.jqueues.r5.entity.jq.queue.processorsharing.SocPS;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;

public final class ProcessorSharingExample {
    private ProcessorSharingExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR nl.jdj.jqueues.processorsharing PACKAGE ===");
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(true, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(DefaultSimEvent.class);
        System.out.println("-> Creating PS queue...");
        PS psQueue = new PS((SimEventList)el);
        System.out.println("-> Submitting jobs to PS queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            psQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating CUPS queue...");
        CUPS cupsQueue = new CUPS((SimEventList)el);
        System.out.println("-> Submitting jobs to CUPS queue (one second inter-arrival time)...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            cupsQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Submitting jobs to CUPS queue (U[0,1] inter-arrival time)...");
        Random RNG = new Random();
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = (double)i + RNG.nextDouble();
            cupsQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating SocPS queue...");
        SocPS socpsQueue = new SocPS((SimEventList)el);
        System.out.println("-> Submitting jobs to SocPS queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = 0.5 * (double)i;
            socpsQueue.scheduleJobArrival(arrTime, j);
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("=== FINISHED ===");
    }
}

