/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.PreemptionStrategy;
import org.javades.jqueues.r5.entity.jq.queue.qos.HOL;
import org.javades.jqueues.r5.entity.jq.queue.qos.PQ;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJobQoS;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventList;

public final class QoSExample {
    private QoSExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR THE qos PACKAGE ===");
        System.out.println("-> Creating jobs for HOL...");
        ArrayList jobList = new ArrayList();
        jobList.add(new DefaultExampleSimJobQoS(true, 1, 10.0, Double.class, Double.valueOf(Double.POSITIVE_INFINITY)));
        jobList.add(new DefaultExampleSimJobQoS(true, 2, 1.0, Double.class, Double.valueOf(0.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 3, 1.0, Double.class, Double.valueOf(-1.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 4, 1.0, Double.class, Double.valueOf(5.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 5, 1.0, Double.class, Double.valueOf(5.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 6, 1.0, Double.class, Double.valueOf(5.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 7, 1.0, Double.class, Double.valueOf(Double.NEGATIVE_INFINITY)));
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(SimEvent.class);
        System.out.println("-> Creating HOL queue...");
        HOL holQueue = new HOL((SimEventList)el, Double.class, Double.POSITIVE_INFINITY);
        System.out.println("-> Submitting jobs to HOL queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> holQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating jobs for PQ...");
        jobList.clear();
        jobList.add(new DefaultExampleSimJobQoS(true, 1, 10.0, Double.class, Double.valueOf(Double.POSITIVE_INFINITY)));
        jobList.add(new DefaultExampleSimJobQoS(true, 2, 1.5, Double.class, Double.valueOf(0.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 3, 2.0, Double.class, Double.valueOf(-1.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 4, 5.0, Double.class, Double.valueOf(5.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 5, 1.0, Double.class, Double.valueOf(5.0)));
        jobList.add(new DefaultExampleSimJobQoS(true, 6, 3.0, Double.class, Double.valueOf(Double.NEGATIVE_INFINITY)));
        jobList.add(new DefaultExampleSimJobQoS(true, 7, 0.5, Double.class, Double.valueOf(Double.NEGATIVE_INFINITY)));
        System.out.println("-> Creating PQ[RESUME] queue...");
        PQ pqQueue = new PQ((SimEventList)el, PreemptionStrategy.RESUME, Double.class, Double.POSITIVE_INFINITY);
        System.out.println("-> Submitting jobs to PQ[RESUME] queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> pqQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("=== FINISHED ===");
    }
}

