/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.AbstractSimQueue;
import org.javades.jqueues.r5.entity.jq.queue.serverless.DELAY;
import org.javades.jqueues.r5.entity.jq.queue.serverless.DROP;
import org.javades.jqueues.r5.entity.jq.queue.serverless.GATE;
import org.javades.jqueues.r5.entity.jq.queue.serverless.SINK;
import org.javades.jqueues.r5.entity.jq.queue.serverless.WUR;
import org.javades.jqueues.r5.entity.jq.queue.serverless.ZERO;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;

public final class ServerlessExample {
    private ServerlessExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR nl.jdj.jqueues PACKAGE ===");
        System.out.println("-> Creating jobs...");
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 10; ++n) {
            jobList.add(new DefaultExampleSimJob(true, n));
        }
        System.out.println("-> Creating event list...");
        DefaultSimEventList el = new DefaultSimEventList(DefaultSimEvent.class);
        System.out.println("-> Creating SINK queue...");
        SINK sinkQueue = new SINK((SimEventList)el);
        System.out.println("-> Submitting jobs to SINK ('Hotel California') queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> sinkQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating DELAY queue with fixed waiting time 4.0...");
        DELAY delayQueue = new DELAY((SimEventList)el, 4.0);
        System.out.println("-> Submitting jobs to DELAY queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> delayQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating other DELAY queue with fixed waiting time ZERO...");
        DELAY delayQueue2 = new DELAY((SimEventList)el, 0.0);
        System.out.println("-> Submitting jobs to (second) DELAY queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> delayQueue2.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating ZERO queue...");
        ZERO zeroQueue = new ZERO((SimEventList)el);
        System.out.println("-> Submitting jobs to ZERO queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> zeroQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating DROP queue...");
        DROP dropQueue = new DROP((SimEventList)el);
        System.out.println("-> Submitting jobs to DROP queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> dropQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating GATE queue...");
        GATE gateQueue = new GATE((SimEventList)el);
        System.out.println("-> Submitting jobs to GATE queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> gateQueue.arrive(arrTime, j)));
        }
        el.schedule(2.5, event -> ((GATE)gateQueue).setGatePassageCredits(event.getTime(), 0));
        el.schedule(3.5, event -> ((GATE)gateQueue).setGatePassageCredits(event.getTime(), Integer.MAX_VALUE));
        el.schedule(5.5, event -> ((GATE)gateQueue).setGatePassageCredits(event.getTime(), 2));
        el.schedule(11.5, event -> ((GATE)gateQueue).setGatePassageCredits(event.getTime(), Integer.MAX_VALUE));
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("-> Creating WUR queue...");
        WUR wurQueue = new WUR((SimEventList)el);
        ((AbstractSimQueue)wurQueue).registerStdOutSimQueueListener();
        System.out.println("-> Submitting jobs to WUR queue...");
        for (int i = 0; i < jobList.size(); ++i) {
            SimJob j = (SimJob)jobList.get(i);
            double arrTime = i + 1;
            el.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, event -> wurQueue.arrive(arrTime, j)));
        }
        System.out.println("-> Executing event list...");
        el.run();
        System.out.println("-> Resetting event list...");
        el.reset();
        System.out.println("=== FINISHED ===");
    }
}

