/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.util.ArrayList;
import java.util.List;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.IS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.misc.example.DefaultExampleSimJob;
import org.javades.jqueues.r5.util.stat.AutoSimQueueStat;
import org.javades.jqueues.r5.util.stat.AutoSimQueueStatEntry;
import org.javades.jqueues.r5.util.stat.SimQueueProbe;
import org.javades.jqueues.r5.util.stat.SimpleSimQueueStat;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEvent;
import org.javades.jsimulation.r5.SimEventAction;
import org.javades.jsimulation.r5.SimEventList;

public final class StatExample {
    private static final SimEventList<DefaultSimEvent> EVENT_LIST = new DefaultSimEventList(DefaultSimEvent.class);
    private static final SimQueue FCFS_QUEUE = new FCFS(EVENT_LIST);
    private static final SimQueue LCFS_QUEUE = new LCFS(EVENT_LIST);
    private static final SimQueue IS_QUEUE = new IS(EVENT_LIST);

    private StatExample() {
    }

    public static void main(String[] args) {
        System.out.println("=== EXAMPLE PROGRAM FOR nl.jdj.jqueues.stat PACKAGE ===");
        int N = 100000;
        System.out.println("-> Simulating queue with 100000 jobs, arriving at 1, 2, 3, ...");
        System.out.println("   Requesting service times 1, 2, 3, ...");
        System.out.println("-> FCFS...");
        EVENT_LIST.reset(1.0);
        ArrayList jobList = new ArrayList();
        for (int n = 1; n <= 100000; ++n) {
            jobList.add(new DefaultExampleSimJob(false, n));
        }
        SimpleSimQueueStat fcfsStat = new SimpleSimQueueStat(FCFS_QUEUE);
        MyAutoSimQueueStat autoFcfsStat = new MyAutoSimQueueStat(FCFS_QUEUE);
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            EVENT_LIST.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    FCFS_QUEUE.arrive(arrTime, j);
                }
            }));
        }
        EVENT_LIST.run();
        System.out.println("   ==> SimpleSimQueueStat");
        System.out.println("     ==> Average number of jobs in queue:  " + fcfsStat.getAvgNrOfJobs() + ".");
        System.out.println("     ==> Average number of jobs in service area: " + fcfsStat.getAvgNrOfJobsInServiceArea() + ".");
        System.out.println("   ==> AutoSimQueueStat");
        autoFcfsStat.report(9);
        System.out.println("-> LCFS...");
        EVENT_LIST.reset(1.0);
        SimpleSimQueueStat lcfsStat = new SimpleSimQueueStat(LCFS_QUEUE);
        MyAutoSimQueueStat autoLcfsStat = new MyAutoSimQueueStat(LCFS_QUEUE);
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            EVENT_LIST.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    LCFS_QUEUE.arrive(arrTime, j);
                }
            }));
        }
        EVENT_LIST.run();
        System.out.println("   ==> SimpleSimQueueStat");
        System.out.println("     ==> Average number of jobs in queue:  " + lcfsStat.getAvgNrOfJobs() + ".");
        System.out.println("     ==> Average number of jobs in service area: " + lcfsStat.getAvgNrOfJobsInServiceArea() + ".");
        System.out.println("   ==> AutoSimQueueStat");
        autoLcfsStat.report(9);
        System.out.println("-> IS...");
        EVENT_LIST.reset(1.0);
        SimpleSimQueueStat isStat = new SimpleSimQueueStat(IS_QUEUE);
        MyAutoSimQueueStat autoIsStat = new MyAutoSimQueueStat(IS_QUEUE);
        for (int i = 0; i < jobList.size(); ++i) {
            final SimJob j = (SimJob)jobList.get(i);
            final double arrTime = i + 1;
            EVENT_LIST.add((Object)new DefaultSimEvent("ARRIVAL_" + i + 1, (double)(i + 1), null, new SimEventAction(){

                public void action(SimEvent event) {
                    IS_QUEUE.arrive(arrTime, j);
                }
            }));
        }
        EVENT_LIST.run();
        System.out.println("   ==> SimpleSimQueueStat");
        System.out.println("     ==> Average number of jobs in queue:  " + isStat.getAvgNrOfJobs() + ".");
        System.out.println("     ==> Average number of jobs in service area: " + isStat.getAvgNrOfJobsInServiceArea() + ".");
        System.out.println("   ==> AutoSimQueueStat");
        autoIsStat.report(9);
        System.out.println("=== FINISHED ===");
    }

    private static class MyAutoSimQueueStat
    extends AutoSimQueueStat<SimJob, SimQueue> {
        private static List<AutoSimQueueStatEntry<SimQueue>> createEntries() {
            ArrayList<AutoSimQueueStatEntry<SimQueue>> list = new ArrayList<AutoSimQueueStatEntry<SimQueue>>();
            list.add(new AutoSimQueueStatEntry<SimQueue>("number of jobs", new SimQueueProbe<SimQueue>(){

                @Override
                public double get(SimQueue queue) {
                    return queue.getNumberOfJobs();
                }
            }));
            list.add(new AutoSimQueueStatEntry<SimQueue>("number of jobs in service area", new SimQueueProbe<SimQueue>(){

                @Override
                public double get(SimQueue queue) {
                    return queue.getNumberOfJobsInServiceArea();
                }
            }));
            return list;
        }

        public MyAutoSimQueueStat(SimQueue queue) {
            super(queue, MyAutoSimQueueStat.createEntries());
        }
    }
}

