/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.misc.example;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.javades.jqueues.r5.entity.jq.job.AbstractSimJob;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.composite.ctandem2.CTandem2;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS;
import org.javades.jqueues.r5.util.swing.JSimQueueComposite;
import org.javades.jqueues.r5.util.swing.JSimQueueCreationDialog;
import org.javades.jsimulation.r5.DefaultSimEvent;
import org.javades.jsimulation.r5.DefaultSimEventList;
import org.javades.jsimulation.r5.SimEventList;
import org.javades.jsimulation.r5.SimEventListListener;
import org.javades.jsimulation.r5.SimEventListResetListener;
import org.javades.jsimulation.r5.swing.JSimEventList;

public final class SwingExample {
    private SwingExample() {
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){
            private JFrame frame;
            private SimEventList eventList;
            private SimQueue queue;
            private JSimQueueComposite jQueue;

            private SimQueue getQueue() {
                return this.queue;
            }

            private void setQueue(SimQueue queue) {
                this.queue = queue;
                this.jQueue.setQueue(this.eventList, this.queue);
                this.frame.invalidate();
                this.frame.pack();
            }

            @Override
            public void run() {
                this.frame = new JFrame("JSimQueue and JSimEventList demonstration.");
                this.frame.setDefaultCloseOperation(3);
                JPanel topPanel = new JPanel();
                topPanel.setLayout(new BoxLayout(topPanel, 3));
                this.frame.getContentPane().add(topPanel);
                this.eventList = new DefaultSimEventList(DefaultSimEvent.class);
                final JLabel timeLabel = new JLabel("Time: " + this.eventList.getTime());
                this.eventList.addListener((SimEventListResetListener)new SimEventListListener(){

                    public final void notifyEventListReset(SimEventList eventList) {
                        timeLabel.setText("Time: " + eventList.getTime());
                    }

                    public final void notifyEventListUpdate(SimEventList eventList, double time) {
                        timeLabel.setText("Time: " + time);
                    }

                    public final void notifyEventListEmpty(SimEventList eventList, double time) {
                    }
                });
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add(timeLabel);
                final JSimEventList jSimEventList = new JSimEventList(this.eventList);
                FCFS fcfs1 = new FCFS(this.eventList);
                FCFS fcfs2 = new FCFS(this.eventList);
                this.queue = new CTandem2(this.eventList, fcfs1, fcfs2, null);
                this.jQueue = new JSimQueueComposite(this.eventList, this.queue);
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add(this.jQueue);
                JPanel buttonPanel = new JPanel();
                buttonPanel.setLayout(new BoxLayout(buttonPanel, 2));
                buttonPanel.add(new JButton(new AbstractAction("Reset"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        eventList.reset();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("New Queue"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        JSimQueueCreationDialog dialog = new JSimQueueCreationDialog((Frame)frame, eventList, this.getQueue());
                        dialog.setVisible(true);
                        if (dialog.getCreatedQueue() != null && dialog.getCreatedQueue() != this.getQueue()) {
                            this.setQueue(dialog.getCreatedQueue());
                        }
                        dialog.dispose();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Arr[Now]"){

                    @Override
                    public final void actionPerformed(ActionEvent ae) {
                        this.getQueue().arrive(eventList.getTime(), new AbstractSimJob(null, null){

                            @Override
                            public double getServiceTime(SimQueue queue) throws IllegalArgumentException {
                                return 10.0;
                            }
                        });
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Arr[Sched]"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        eventList.scheduleNow(event -> this.getQueue().arrive(eventList.getTime(), new AbstractSimJob(null, null){

                            @Override
                            public double getServiceTime(SimQueue queue1) throws IllegalArgumentException {
                                return 10.0;
                            }
                        }));
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Step"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        eventList.runSingleStep();
                        jSimEventList.eventListChangedNotification();
                    }
                }));
                buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
                buttonPanel.add(new JButton(new AbstractAction("Run"){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        eventList.run();
                    }
                }));
                buttonPanel.setAlignmentY(0.5f);
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add(buttonPanel);
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                topPanel.add((Component)jSimEventList);
                topPanel.add(Box.createRigidArea(new Dimension(0, 10)));
                this.frame.pack();
                this.frame.setLocationRelativeTo(null);
                this.frame.setVisible(true);
            }
        });
    }
}

