/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.collection;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;

public class HashMapWithPreImageAndOrderedValueSet<K, V>
extends HashMap<K, V> {
    private TreeMap<V, Set<K>> preImage = new TreeMap();

    @Override
    public HashMapWithPreImageAndOrderedValueSet clone() {
        HashMapWithPreImageAndOrderedValueSet treeMapWithPreImage = (HashMapWithPreImageAndOrderedValueSet)super.clone();
        treeMapWithPreImage.preImage = new TreeMap<Set<K>, Set<V>>(this.preImage);
        return treeMapWithPreImage;
    }

    @Override
    public void clear() {
        super.clear();
        this.preImage.clear();
    }

    private void removePreImage(Object key, V value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (!this.preImage.containsKey(value) || this.preImage.get(value) == null || !this.preImage.get(value).contains(key)) {
            throw new RuntimeException();
        }
        this.preImage.get(value).remove(key);
        if (this.preImage.get(value).isEmpty()) {
            this.preImage.remove(value);
        }
    }

    @Override
    public V remove(Object key) {
        if (this.containsKey(null)) {
            throw new RuntimeException();
        }
        Object oldValue = super.remove(key);
        if (oldValue != null) {
            this.removePreImage(key, oldValue);
        }
        return oldValue;
    }

    @Override
    public V put(K key, V value) {
        if (this.containsKey(null)) {
            throw new RuntimeException();
        }
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        V oldValue = super.put(key, value);
        if (oldValue != null) {
            this.removePreImage(key, oldValue);
        }
        if (!this.preImage.containsKey(value)) {
            this.preImage.put(value, (Set<V>)new HashSet());
        }
        this.preImage.get(value).add(key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        if (this.containsKey(null)) {
            throw new RuntimeException();
        }
        if (map == null || map.containsKey(null) || map.containsValue(null)) {
            throw new NullPointerException();
        }
        for (Map.Entry<K, V> me : map.entrySet()) {
            this.put(me.getKey(), me.getValue());
        }
    }

    public V firstValue() throws NoSuchElementException {
        return this.preImage.firstKey();
    }

    public Set<K> getPreImageForValue(V value) {
        if (this.containsKey(null)) {
            throw new RuntimeException();
        }
        Set<K> keys = this.preImage.get(value);
        if (keys != null) {
            return new LinkedHashSet<K>(keys);
        }
        return new LinkedHashSet();
    }

    public Set<K> getPreImageForSet(Set<V> values) {
        if (this.containsKey(null)) {
            throw new RuntimeException();
        }
        if (values == null) {
            throw new NullPointerException();
        }
        LinkedHashSet<K> preImage = new LinkedHashSet<K>();
        for (V value : values) {
            preImage.addAll(this.getPreImageForValue(value));
        }
        return preImage;
    }
}

