/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.loadfactory.AbstractLoadFactory_SQ_SV;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0010<J extends SimJob, Q extends SimQueue>
extends AbstractLoadFactory_SQ_SV<J, Q> {
    public static final LoadFactoryHint SERVICE_TIME_JITTER = new LoadFactoryHint(){

        public final String toString() {
            return "SERVICE_TIME_JITTER";
        }
    };
    private final Random rngRequestedServiceTimeJitter = new Random();

    @Override
    public String getDescription() {
        return "Standard test load pattern A1=1/S1=1, A2=2/S2=2, ..., with optional service-time jitter.";
    }

    protected Map<Q, Double> generateRequestedServiceTimeMap(Q queue, int n, boolean jitter) {
        HashMap<Q, Double> requestedServiceTimeMap = new HashMap<Q, Double>();
        double requestedServiceTimeJitter = jitter ? 0.01 * (2.0 * this.rngRequestedServiceTimeJitter.nextDouble() - 1.0) : 0.0;
        requestedServiceTimeMap.put(queue, (double)n + requestedServiceTimeJitter);
        return requestedServiceTimeMap;
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        if (eventList == null || queue == null || jobFactory == null) {
            throw new IllegalArgumentException();
        }
        if (numberOfJobs < 0) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<J> jobs = new LinkedHashSet<J>();
        TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
        LinkedHashSet eventsToSchedule = new LinkedHashSet();
        SimEventList jobEventList = attachSimJobsToEventList ? eventList : null;
        boolean jitter = hints != null && hints.contains(SERVICE_TIME_JITTER);
        for (int i = 1; i <= numberOfJobs; ++i) {
            J job = jobFactory.newInstance(jobEventList, Integer.toString(i), this.generateRequestedServiceTimeMap(queue, i, jitter));
            SimJQEvent.Arrival<J, Q> arrivalSchedule = new SimJQEvent.Arrival<J, Q>(job, queue, i);
            if (!realQueueExternalEvents.containsKey(i)) {
                realQueueExternalEvents.put(Double.valueOf(i), new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(i)).add(arrivalSchedule);
            eventsToSchedule.add(arrivalSchedule);
            jobs.add(job);
        }
        SimJQEventScheduler.scheduleJQ(eventList, reset, resetTime, eventsToSchedule);
        return jobs;
    }
}

