/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jqueues.r5.util.loadfactory.pattern.LoadFactory_SQ_SV_0010;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0011<J extends SimJob, Q extends SimQueue>
extends LoadFactory_SQ_SV_0010<J, Q> {
    @Override
    public String getDescription() {
        return "Standard pattern (0010) with qav from 2.5-3.5, 5.5-6.5, etc., dropping every third job.";
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        Set<J> jobs = super.generate(eventList, attachSimJobsToEventList, queue, jobFactory, numberOfJobs, reset, resetTime, hints, queueExternalEvents);
        TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
        int numberOfQavToSchedule = Math.max(1, jobs.size() / 3);
        LinkedHashSet eventsToSchedule = new LinkedHashSet();
        for (int i = 1; i <= numberOfQavToSchedule; ++i) {
            double startQavTime = 3.0 * (double)i - 0.5;
            double endQavTime = 3.0 * (double)i + 0.5;
            SimQueueEvent.QueueAccessVacation qavOnSchedule = new SimQueueEvent.QueueAccessVacation(queue, startQavTime, true);
            if (!realQueueExternalEvents.containsKey(startQavTime)) {
                realQueueExternalEvents.put(startQavTime, new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(startQavTime)).add(qavOnSchedule);
            eventsToSchedule.add(qavOnSchedule);
            SimQueueEvent.QueueAccessVacation qavOffSchedule = new SimQueueEvent.QueueAccessVacation(queue, endQavTime, false);
            if (!realQueueExternalEvents.containsKey(endQavTime)) {
                realQueueExternalEvents.put(endQavTime, new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(endQavTime)).add(qavOffSchedule);
            eventsToSchedule.add(qavOffSchedule);
        }
        SimJQEventScheduler.scheduleJQ(eventList, false, Double.NaN, eventsToSchedule);
        return jobs;
    }
}

