/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jqueues.r5.util.loadfactory.pattern.LoadFactory_SQ_SV_0010;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0012<J extends SimJob, Q extends SimQueue>
extends LoadFactory_SQ_SV_0010<J, Q> {
    @Override
    public String getDescription() {
        return "Standard pattern (0010) with revocation request for every 5th job with random request time and random interrupt flag.";
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        Set<J> jobs = super.generate(eventList, attachSimJobsToEventList, queue, jobFactory, numberOfJobs, reset, resetTime, hints, queueExternalEvents);
        TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
        LinkedHashSet eventsToSchedule = new LinkedHashSet();
        Iterator<J> i_jobs = jobs.iterator();
        Random rngInterrupt = new Random();
        Random rngDelay = new Random();
        for (int i = 1; i <= jobs.size(); ++i) {
            SimJob job = (SimJob)i_jobs.next();
            if (i % 5 != 0) continue;
            double arrivalTime = i;
            double serviceTime = i;
            double expWorkArrived = 0.5 * (double)i * (double)(i + 1);
            double expWorkDone = i - 1;
            double expWait = expWorkArrived - expWorkDone - serviceTime;
            boolean interruptService = rngInterrupt.nextBoolean();
            double delay = interruptService ? expWait + serviceTime * rngDelay.nextDouble() : expWait * rngDelay.nextDouble();
            double revocationTime = arrivalTime + delay;
            SimJQEvent.Revocation<SimJob, Q> revocationSchedule = new SimJQEvent.Revocation<SimJob, Q>(job, queue, revocationTime, interruptService);
            if (!realQueueExternalEvents.containsKey(revocationTime)) {
                realQueueExternalEvents.put(revocationTime, new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(revocationTime)).add(revocationSchedule);
            eventsToSchedule.add(revocationSchedule);
        }
        SimJQEventScheduler.scheduleJQ(eventList, false, Double.NaN, eventsToSchedule);
        return jobs;
    }
}

