/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jqueues.r5.util.loadfactory.pattern.LoadFactory_SQ_SV_0010;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0013<J extends SimJob, Q extends SimQueue>
extends LoadFactory_SQ_SV_0010<J, Q> {
    @Override
    public String getDescription() {
        return "Standard pattern (0010) with random sac=0/1/2 settings @t=6.75, @t=13.75, @t=20.75, ..., with upto 0.001 jitter.";
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        Set<J> jobs = super.generate(eventList, attachSimJobsToEventList, queue, jobFactory, numberOfJobs, reset, resetTime, hints, queueExternalEvents);
        TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
        int numberOfSacToSchedule = Math.max(1, jobs.size() * (jobs.size() + 1) / 7);
        LinkedHashSet eventsToSchedule = new LinkedHashSet();
        Random rngScheduleTimeJitter = new Random();
        Random rngCredits = new Random();
        for (int i = 1; i <= numberOfSacToSchedule; ++i) {
            double scheduleTimeJitter = 0.001 * (2.0 * rngScheduleTimeJitter.nextDouble() - 1.0);
            double scheduleTime = 7.0 * (double)i - 0.25 + scheduleTimeJitter;
            int credits = rngCredits.nextInt(3);
            SimQueueEvent.ServerAccessCredits sacSchedule = new SimQueueEvent.ServerAccessCredits(queue, scheduleTime, credits);
            if (!realQueueExternalEvents.containsKey(scheduleTime)) {
                realQueueExternalEvents.put(scheduleTime, new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(scheduleTime)).add(sacSchedule);
            eventsToSchedule.add(sacSchedule);
        }
        SimJQEventScheduler.scheduleJQ(eventList, false, Double.NaN, eventsToSchedule);
        return jobs;
    }
}

