/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.LinkedHashSet;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueEvent;
import org.javades.jqueues.r5.extensions.gate.SimQueueGateEvent;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGate;
import org.javades.jqueues.r5.extensions.gate.SimQueueWithGateOperationUtils;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jqueues.r5.util.loadfactory.pattern.LoadFactory_SQ_SV_0010;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0014<J extends SimJob, Q extends SimQueue>
extends LoadFactory_SQ_SV_0010<J, Q> {
    public static final LoadFactoryHint FORCE_GPC = new LoadFactoryHint(){

        public final String toString() {
            return "FORCE_GPC";
        }
    };
    public static final LoadFactoryHint DISABLE_GPC = new LoadFactoryHint(){

        public final String toString() {
            return "DISABLE_GPC";
        }
    };

    @Override
    public String getDescription() {
        return "Standard pattern (0010) with random (0, 1, 5, infty) gate-passage-credits settings @t=11.19, @t=22.19, @t=33.19, ....";
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        boolean disableGpc;
        Set<J> jobs = super.generate(eventList, attachSimJobsToEventList, queue, jobFactory, numberOfJobs, reset, resetTime, hints, queueExternalEvents);
        boolean forceGpc = hints != null && hints.contains(FORCE_GPC);
        boolean bl = disableGpc = hints != null && hints.contains(DISABLE_GPC);
        if (forceGpc && disableGpc) {
            throw new IllegalArgumentException();
        }
        if (!disableGpc && (forceGpc || queue instanceof SimQueueWithGate || queue.getRegisteredOperations().contains(SimQueueWithGateOperationUtils.GatePassageCreditsOperation.getInstance()))) {
            TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
            int numberOfGateEventsToSchedule = Math.max(1, jobs.size() * (jobs.size() + 1) / 11);
            LinkedHashSet eventsToSchedule = new LinkedHashSet();
            Random rngPassageCredits = new Random();
            for (int i = 1; i <= numberOfGateEventsToSchedule; ++i) {
                SimJQEvent gateSchedule;
                int gatePassageCredits;
                double scheduleTime = 11.0 * (double)i + 0.19;
                int draw = rngPassageCredits.nextInt(4);
                switch (draw) {
                    case 0: {
                        gatePassageCredits = 0;
                        break;
                    }
                    case 1: {
                        gatePassageCredits = 1;
                        break;
                    }
                    case 2: {
                        gatePassageCredits = 5;
                        break;
                    }
                    case 3: {
                        gatePassageCredits = Integer.MAX_VALUE;
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                if (queue instanceof SimQueueWithGate) {
                    gateSchedule = new SimQueueGateEvent(queue, scheduleTime, gatePassageCredits);
                } else {
                    SimQueueWithGateOperationUtils.GatePassageCreditsRequest request = new SimQueueWithGateOperationUtils.GatePassageCreditsRequest((SimQueue)queue, gatePassageCredits);
                    gateSchedule = new SimQueueEvent.Operation(queue, scheduleTime, request);
                }
                if (!realQueueExternalEvents.containsKey(scheduleTime)) {
                    realQueueExternalEvents.put(scheduleTime, new LinkedHashSet());
                }
                ((Set)realQueueExternalEvents.get(scheduleTime)).add(gateSchedule);
                eventsToSchedule.add(gateSchedule);
            }
            SimJQEventScheduler.scheduleJQ(eventList, false, Double.NaN, eventsToSchedule);
        }
        return jobs;
    }
}

