/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.loadfactory.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.SimJQEventScheduler;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.SimJobFactory;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.extensions.qos.SimJobQoS;
import org.javades.jqueues.r5.util.loadfactory.AbstractLoadFactory_SQ_SV;
import org.javades.jqueues.r5.util.loadfactory.LoadFactoryHint;
import org.javades.jsimulation.r5.SimEventList;

public class LoadFactory_SQ_SV_0100<J extends SimJob, Q extends SimQueue>
extends AbstractLoadFactory_SQ_SV<J, Q> {
    private final Random rngRequestedServiceTime = new Random();

    @Override
    public String getDescription() {
        return "Jobs with U[0.95, 9.5] requested service times and random Double QoS values (incl. +/- infinity).";
    }

    protected Map<Q, Double> generateRequestedServiceTimeMap(Q queue, int n) {
        HashMap<Q, Double> requestedServiceTimeMap = new HashMap<Q, Double>();
        double requestedServiceTime = 0.5 + 9.0 * this.rngRequestedServiceTime.nextDouble();
        requestedServiceTimeMap.put(queue, requestedServiceTime);
        return requestedServiceTimeMap;
    }

    @Override
    public Set<J> generate(SimEventList eventList, boolean attachSimJobsToEventList, Q queue, SimJobFactory<J, Q> jobFactory, int numberOfJobs, boolean reset, double resetTime, Set<LoadFactoryHint> hints, NavigableMap<Double, Set<SimJQEvent>> queueExternalEvents) {
        if (eventList == null || queue == null || jobFactory == null) {
            throw new IllegalArgumentException();
        }
        if (numberOfJobs < 0) {
            throw new IllegalArgumentException();
        }
        LinkedHashSet<J> jobs = new LinkedHashSet<J>();
        TreeMap realQueueExternalEvents = queueExternalEvents != null ? queueExternalEvents : new TreeMap();
        LinkedHashSet eventsToSchedule = new LinkedHashSet();
        SimEventList jobEventList = attachSimJobsToEventList ? eventList : null;
        ArrayList<Double> qosList = new ArrayList<Double>();
        qosList.add(null);
        Random rngQoS = new Random();
        for (int i = 0; i < 7; ++i) {
            qosList.add(2.0 * (-8.988465674311579E307 + Double.MAX_VALUE * rngQoS.nextDouble()));
        }
        qosList.add(0.0);
        qosList.add(Double.NEGATIVE_INFINITY);
        qosList.add(Double.POSITIVE_INFINITY);
        Random rngQoSSelect = new Random();
        for (int i = 1; i <= numberOfJobs; ++i) {
            J job = jobFactory.newInstance(jobEventList, Integer.toString(i), this.generateRequestedServiceTimeMap(queue, i));
            ((SimJobQoS)job).setQoSClass(Double.class);
            ((SimJobQoS)job).setQoS(qosList.get(rngQoSSelect.nextInt(qosList.size())));
            SimJQEvent.Arrival<J, Q> arrivalSchedule = new SimJQEvent.Arrival<J, Q>(job, queue, i);
            if (!realQueueExternalEvents.containsKey(i)) {
                realQueueExternalEvents.put(Double.valueOf(i), new LinkedHashSet());
            }
            ((Set)realQueueExternalEvents.get(i)).add(arrivalSchedule);
            eventsToSchedule.add(arrivalSchedule);
            jobs.add(job);
        }
        SimJQEventScheduler.scheduleJQ(eventList, reset, resetTime, eventsToSchedule);
        return jobs;
    }
}

