/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.FCFS_B;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LCFS;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.LJF;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.NoBuffer_c;
import org.javades.jqueues.r5.entity.jq.queue.nonpreemptive.SJF;
import org.javades.jqueues.r5.entity.jq.queue.preemptive.P_LCFS;
import org.javades.jqueues.r5.util.predictor.DefaultSimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionInvalidInputException;
import org.javades.jqueues.r5.util.predictor.SimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleAmbiguityException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public abstract class AbstractSimQueuePredictor<Q extends SimQueue>
implements SimQueuePredictor<Q> {
    @Override
    public SimQueuePrediction_SQ_SV<Q> predict_SQ_SV_ROEL_U(Q queue, Set<SimJQEvent> workloadEvents) throws SimQueuePredictionException {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        HashSet visitLogsSet = new HashSet();
        ArrayList<Map<Double, Boolean>> qavLog = new ArrayList<Map<Double, Boolean>>();
        ArrayList<Map<Double, Boolean>> sacLog = new ArrayList<Map<Double, Boolean>>();
        ArrayList<Map<Double, Boolean>> staLog = new ArrayList<Map<Double, Boolean>>();
        try {
            WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule = this.createWorkloadSchedule_SQ_SV_ROEL_U(queue, workloadEvents);
            SimQueueState<SimJob, Q> queueState = this.createQueueState(queue, true);
            if (!Double.isNaN(queueState.getTime())) {
                throw new RuntimeException();
            }
            HashSet<SimEntitySimpleEventType.Member> hashSet = new HashSet<SimEntitySimpleEventType.Member>();
            HashSet<SimEntitySimpleEventType.Member> queueEventTypes = new HashSet<SimEntitySimpleEventType.Member>();
            boolean finished = false;
            boolean isQav = false;
            boolean hasSac = this.hasServerAccessCredits(queue, queueState);
            boolean isSta = this.isStartArmed(queue, queueState);
            while (!finished) {
                double nextEventTime;
                boolean doQueueEvent;
                boolean hasQueueEvent;
                double time = queueState.getTime();
                hashSet.clear();
                queueEventTypes.clear();
                double nextWorkloadEventTime = workloadSchedule.getNextEventTimeBeyond((SimQueue)queue, time, (Set<SimEntitySimpleEventType.Member>)hashSet);
                double nextQueueEventTime = this.getNextQueueEventTimeBeyond(queue, queueState, queueEventTypes);
                boolean hasWorkloadEvent = !Double.isNaN(nextWorkloadEventTime);
                boolean bl = hasQueueEvent = !Double.isNaN(nextQueueEventTime);
                if (hasWorkloadEvent) {
                    if (hashSet.isEmpty()) {
                        throw new RuntimeException();
                    }
                    if (hashSet.size() > 1) {
                        throw new SimQueuePredictionAmbiguityException();
                    }
                }
                if (hasQueueEvent) {
                    if (queueEventTypes.isEmpty()) {
                        throw new RuntimeException();
                    }
                    if (queueEventTypes.size() > 1) {
                        throw new SimQueuePredictionAmbiguityException();
                    }
                }
                boolean doWorkloadEvent = hasWorkloadEvent && (!hasQueueEvent || nextWorkloadEventTime <= nextQueueEventTime);
                boolean bl2 = doQueueEvent = hasQueueEvent && (!hasWorkloadEvent || nextQueueEventTime <= nextWorkloadEventTime);
                double d = doWorkloadEvent ? nextWorkloadEventTime : (nextEventTime = doQueueEvent ? nextQueueEventTime : Double.NaN);
                if (doWorkloadEvent || doQueueEvent) {
                    this.updateToTime(queue, queueState, nextEventTime);
                    if (queueState.getTime() != nextEventTime) {
                        throw new RuntimeException();
                    }
                    if (this.isQueueAccessVacation(queue, queueState) != isQav) {
                        throw new RuntimeException();
                    }
                    if (this.hasServerAccessCredits(queue, queueState) != hasSac) {
                        throw new RuntimeException();
                    }
                    if (this.isStartArmed(queue, queueState) != isSta) {
                        throw new RuntimeException();
                    }
                }
                if (doWorkloadEvent && doQueueEvent && !this.is_ROEL_U_UnderWorkloadQueueEventClashes(queue, queueState, workloadSchedule, hashSet, queueEventTypes)) {
                    throw new SimQueuePredictionAmbiguityException();
                }
                if (doQueueEvent) {
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, queueEventTypes, visitLogsSet);
                }
                if (doWorkloadEvent) {
                    this.doWorkloadEvents_SQ_SV_ROEL_U(queue, workloadSchedule, queueState, hashSet, visitLogsSet);
                }
                if ((doWorkloadEvent || doQueueEvent) && queueState.getTime() != nextEventTime) {
                    throw new RuntimeException();
                }
                if (this.isQueueAccessVacation(queue, queueState) != isQav) {
                    isQav = !isQav;
                    qavLog.add(Collections.singletonMap(nextEventTime, isQav));
                }
                if (this.hasServerAccessCredits(queue, queueState) != hasSac) {
                    hasSac = !hasSac;
                    sacLog.add(Collections.singletonMap(nextEventTime, hasSac));
                }
                if (this.isStartArmed(queue, queueState) != isSta) {
                    isSta = !isSta;
                    staLog.add(Collections.singletonMap(nextEventTime, isSta));
                }
                finished = !hasWorkloadEvent && !hasQueueEvent;
            }
        }
        catch (WorkloadScheduleAmbiguityException wsae) {
            throw new SimQueuePredictionAmbiguityException(wsae);
        }
        catch (WorkloadScheduleException wse) {
            throw new SimQueuePredictionInvalidInputException(wse);
        }
        HashMap visitLogs = new HashMap();
        for (JobQueueVisitLog jobQueueVisitLog : visitLogsSet) {
            if (jobQueueVisitLog == null) {
                throw new RuntimeException();
            }
            if (jobQueueVisitLog.queue != queue) {
                throw new RuntimeException();
            }
            if (visitLogs.containsKey(jobQueueVisitLog.job)) {
                throw new RuntimeException();
            }
            visitLogs.put((SimJob)jobQueueVisitLog.job, jobQueueVisitLog);
        }
        return new DefaultSimQueuePrediction_SQ_SV<Q>(queue, visitLogs, qavLog, sacLog, staLog);
    }

    @Override
    public SimQueuePrediction_SQ_SV<Q> predict_SQ_SV_IOEL_U(Q queue, NavigableMap<Double, Set<SimJQEvent>> workloadEventsMap, NavigableMap<Double, Set<SimJQEvent>> processedEventsMap) throws SimQueuePredictionException {
        if (queue == null) {
            throw new IllegalArgumentException();
        }
        HashSet visitLogsSet = new HashSet();
        ArrayList<Map<Double, Boolean>> qavLog = new ArrayList<Map<Double, Boolean>>();
        ArrayList<Map<Double, Boolean>> sacLog = new ArrayList<Map<Double, Boolean>>();
        ArrayList<Map<Double, Boolean>> staLog = new ArrayList<Map<Double, Boolean>>();
        try {
            WorkloadSchedule_SQ_SV workloadSchedule = this.createWorkloadSchedule_SQ_SV(queue, workloadEventsMap);
            SimQueueState<SimJob, Q> queueState = this.createQueueState(queue, true);
            if (!Double.isNaN(queueState.getTime())) {
                throw new RuntimeException();
            }
            HashSet<SimEntitySimpleEventType.Member> hashSet = new HashSet<SimEntitySimpleEventType.Member>();
            HashSet<SimEntitySimpleEventType.Member> queueEventTypes = new HashSet<SimEntitySimpleEventType.Member>();
            boolean finished = false;
            boolean isQav = false;
            boolean hasSac = this.hasServerAccessCredits(queue, queueState);
            boolean isSta = this.isStartArmed(queue, queueState);
            while (!finished) {
                double nextEventTime;
                boolean doQueueEvent;
                boolean hasQueueEvent;
                double time = queueState.getTime();
                hashSet.clear();
                queueEventTypes.clear();
                double nextWorkloadEventTime = workloadSchedule.getNextEventTimeBeyond((SimQueue)queue, time, (Set<SimEntitySimpleEventType.Member>)hashSet);
                double nextQueueEventTime = this.getNextQueueEventTimeBeyond(queue, queueState, queueEventTypes);
                boolean hasWorkloadEvent = !Double.isNaN(nextWorkloadEventTime);
                boolean bl = hasQueueEvent = !Double.isNaN(nextQueueEventTime);
                if (hasWorkloadEvent && hashSet.isEmpty()) {
                    throw new RuntimeException();
                }
                if (hasQueueEvent) {
                    if (queueEventTypes.isEmpty()) {
                        throw new RuntimeException();
                    }
                    if (queueEventTypes.size() > 1) {
                        throw new SimQueuePredictionAmbiguityException();
                    }
                }
                boolean doWorkloadEvent = hasWorkloadEvent && (!hasQueueEvent || nextWorkloadEventTime <= nextQueueEventTime);
                boolean bl2 = doQueueEvent = hasQueueEvent && (!hasWorkloadEvent || nextQueueEventTime <= nextWorkloadEventTime);
                double d = doWorkloadEvent ? nextWorkloadEventTime : (nextEventTime = doQueueEvent ? nextQueueEventTime : Double.NaN);
                if (doWorkloadEvent || doQueueEvent) {
                    this.updateToTime(queue, queueState, nextEventTime);
                    if (queueState.getTime() != nextEventTime) {
                        throw new RuntimeException();
                    }
                    if (this.isQueueAccessVacation(queue, queueState) != isQav) {
                        throw new RuntimeException();
                    }
                    if (this.hasServerAccessCredits(queue, queueState) != hasSac) {
                        throw new RuntimeException();
                    }
                    if (this.isStartArmed(queue, queueState) != isSta) {
                        throw new RuntimeException();
                    }
                }
                if (doWorkloadEvent && doQueueEvent && !this.is_U_UnderWorkloadQueueEventClashes(queue, queueState, workloadSchedule, queueEventTypes)) {
                    throw new SimQueuePredictionAmbiguityException();
                }
                if (doQueueEvent) {
                    this.doQueueEvents_SQ_SV_ROEL_U(queue, queueState, queueEventTypes, visitLogsSet);
                }
                if (doWorkloadEvent) {
                    this.doWorkloadEvents_SQ_SV(queue, workloadSchedule, queueState, visitLogsSet);
                }
                if ((doWorkloadEvent || doQueueEvent) && queueState.getTime() != nextEventTime) {
                    throw new RuntimeException();
                }
                if (this.isQueueAccessVacation(queue, queueState) != isQav) {
                    isQav = !isQav;
                    qavLog.add(Collections.singletonMap(nextEventTime, isQav));
                }
                if (this.hasServerAccessCredits(queue, queueState) != hasSac) {
                    hasSac = !hasSac;
                    sacLog.add(Collections.singletonMap(nextEventTime, hasSac));
                }
                if (this.isStartArmed(queue, queueState) != isSta) {
                    isSta = !isSta;
                    staLog.add(Collections.singletonMap(nextEventTime, isSta));
                }
                finished = !hasWorkloadEvent && !hasQueueEvent;
            }
        }
        catch (WorkloadScheduleAmbiguityException wsae) {
            throw new SimQueuePredictionAmbiguityException(wsae);
        }
        catch (WorkloadScheduleException wse) {
            throw new SimQueuePredictionInvalidInputException(wse);
        }
        HashMap visitLogs = new HashMap();
        for (JobQueueVisitLog jobQueueVisitLog : visitLogsSet) {
            if (jobQueueVisitLog == null) {
                throw new RuntimeException();
            }
            if (jobQueueVisitLog.queue != queue) {
                throw new RuntimeException();
            }
            if (visitLogs.containsKey(jobQueueVisitLog.job)) {
                throw new RuntimeException();
            }
            visitLogs.put((SimJob)jobQueueVisitLog.job, jobQueueVisitLog);
        }
        return new DefaultSimQueuePrediction_SQ_SV<Q>(queue, visitLogs, qavLog, sacLog, staLog);
    }

    protected boolean is_ROEL_U_UnderWorkloadQueueEventClashes(Q queue, SimQueueState<SimJob, Q> queueState, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || Double.isNaN(queueState.getTime()) || workloadSchedule == null || workloadEventTypes == null || workloadEventTypes.isEmpty() || workloadEventTypes.contains(null) || queueEventTypes == null || queueEventTypes.isEmpty() || queueEventTypes.contains(null)) {
            throw new IllegalArgumentException();
        }
        for (SimEntitySimpleEventType.Member wEvent : workloadEventTypes) {
            for (SimEntitySimpleEventType.Member qEvent : queueEventTypes) {
                if (wEvent == SimQueueSimpleEventType.REVOCATION && qEvent == SimQueueSimpleEventType.DEPARTURE) {
                    return false;
                }
                if (wEvent == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS && (qEvent == SimQueueSimpleEventType.DEPARTURE || qEvent == SimQueueSimpleEventType.START)) {
                    return false;
                }
                if (wEvent != SimQueueSimpleEventType.ARRIVAL || qEvent != SimQueueSimpleEventType.DEPARTURE && qEvent != SimQueueSimpleEventType.START || !(queue instanceof FCFS_B) && !(queue instanceof LCFS) && !(queue instanceof NoBuffer_c) && !(queue instanceof SJF) && !(queue instanceof LJF) && !(queue instanceof P_LCFS)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean is_U_UnderWorkloadQueueEventClashes(Q queue, SimQueueState<SimJob, Q> queueState, WorkloadSchedule_SQ_SV workloadSchedule, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || Double.isNaN(queueState.getTime()) || workloadSchedule == null || queueEventTypes == null || queueEventTypes.isEmpty() || queueEventTypes.contains(null)) {
            throw new IllegalArgumentException();
        }
        double time = queueState.getTime();
        Set events = (Set)workloadSchedule.getSimQueueTimeSimEntityEventMap().get(queue).get(time);
        try {
            for (SimJQEvent event : events) {
                WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule_SQ_SV_ROEL_U = this.createWorkloadSchedule_SQ_SV_ROEL_U(queue, Collections.singleton(event));
                HashSet<SimEntitySimpleEventType.Member> workloadEventTypes = new HashSet<SimEntitySimpleEventType.Member>();
                workloadSchedule_SQ_SV_ROEL_U.getNextEventTimeBeyond((SimQueue)queue, Double.NaN, (Set<SimEntitySimpleEventType.Member>)workloadEventTypes);
                if (this.is_ROEL_U_UnderWorkloadQueueEventClashes(queue, queueState, workloadSchedule_SQ_SV_ROEL_U, workloadEventTypes, queueEventTypes)) continue;
                return false;
            }
            return true;
        }
        catch (WorkloadScheduleException wse) {
            throw new RuntimeException(wse);
        }
    }
}

