/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.javades.jqueues.r5.entity.jq.SimJQEvent;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueue;
import org.javades.jqueues.r5.util.predictor.SimQueueEventPredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.SimQueuePrediction_SQ_SV;
import org.javades.jqueues.r5.util.predictor.SimQueueStatePredictor;

public interface SimQueuePredictor<Q extends SimQueue>
extends SimQueueEventPredictor<Q>,
SimQueueStatePredictor<Q> {
    public SimQueuePrediction_SQ_SV<Q> predict_SQ_SV_ROEL_U(Q var1, Set<SimJQEvent> var2) throws SimQueuePredictionException;

    public SimQueuePrediction_SQ_SV<Q> predict_SQ_SV_IOEL_U(Q var1, NavigableMap<Double, Set<SimJQEvent>> var2, NavigableMap<Double, Set<SimJQEvent>> var3) throws SimQueuePredictionException;

    public static <Q extends SimQueue> boolean matchVisitLogs_SQ_SV(Q queue, Map<SimJob, JobQueueVisitLog<SimJob, Q>> predicted, Map<SimJob, TreeMap<Double, TreeMap<Integer, JobQueueVisitLog<SimJob, Q>>>> actual, double accuracy, PrintStream stream, String testString) {
        if (queue == null || predicted == null || actual == null || accuracy < 0.0) {
            throw new IllegalArgumentException();
        }
        HashMap<SimJob, JobQueueVisitLog<SimJob, Q>> predictedAtQueue = new HashMap<SimJob, JobQueueVisitLog<SimJob, Q>>();
        for (Map.Entry<SimJob, JobQueueVisitLog<SimJob, Q>> entry : predicted.entrySet()) {
            if (entry.getValue().queue != queue) continue;
            predictedAtQueue.put(entry.getKey(), entry.getValue());
        }
        HashMap<SimJob, JobQueueVisitLog<SimJob, Q>> actualAtQueue = new HashMap<SimJob, JobQueueVisitLog<SimJob, Q>>();
        boolean success = true;
        for (Map.Entry<SimJob, TreeMap<Double, TreeMap<Integer, JobQueueVisitLog<SimJob, Q>>>> entry : actual.entrySet()) {
            if (entry == null) {
                throw new IllegalArgumentException();
            }
            SimJob job = entry.getKey();
            for (Map.Entry<Double, TreeMap<Integer, JobQueueVisitLog<SimJob, Q>>> timeEntry : entry.getValue().entrySet()) {
                if (timeEntry == null) {
                    throw new IllegalArgumentException();
                }
                for (Map.Entry<Integer, JobQueueVisitLog<SimJob, Q>> sequenceEntry : timeEntry.getValue().entrySet()) {
                    if (sequenceEntry.getValue().queue != queue) continue;
                    if (actualAtQueue.containsKey(job)) {
                        success = false;
                        if (stream != null) {
                            stream.println("[matchVisitLogs_SQ_SV:] Found multiple visits of job " + job + " to queue " + queue + ".");
                            if (testString == null) continue;
                            stream.println("  Test: ");
                            stream.println(testString);
                            continue;
                        }
                        return false;
                    }
                    actualAtQueue.put(job, sequenceEntry.getValue());
                }
            }
        }
        for (SimJob job : predictedAtQueue.keySet()) {
            JobQueueVisitLog actualVisitLog;
            JobQueueVisitLog predictedVisitLog = (JobQueueVisitLog)predictedAtQueue.get(job);
            if (!actualAtQueue.containsKey(job)) {
                success = false;
                if (stream != null) {
                    stream.println("[matchVisitLogs_SQ_SV] Absent predicted visit of job " + job + " to queue " + queue + ":");
                    if (testString != null) {
                        stream.println("  Test: ");
                        stream.println(testString);
                    }
                    stream.println("Predicted visit log: ");
                    predictedVisitLog.print(stream);
                } else {
                    return false;
                }
            }
            if ((actualVisitLog = (JobQueueVisitLog)actualAtQueue.get(job)) == null || actualVisitLog.equals(predictedVisitLog, accuracy)) continue;
            success = false;
            if (stream != null) {
                stream.println("[matchVisitLogs_SQ_SV: Found mismatch for visit of job " + job + " to queue " + queue + ":");
                if (testString != null) {
                    stream.println("  Test: ");
                    stream.println(testString);
                }
                stream.println("Accuracy = " + accuracy + ".");
                stream.println("Predicted and actual visit logs: ");
                predictedVisitLog.print(stream);
                actualVisitLog.print(stream);
                continue;
            }
            return false;
        }
        return success;
    }
}

