/*
 * Decompiled with CFR 0.152.
 */
package org.javades.jqueues.r5.util.predictor.queues;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.javades.jqueues.r5.entity.SimEntitySimpleEventType;
import org.javades.jqueues.r5.entity.jq.job.SimJob;
import org.javades.jqueues.r5.entity.jq.job.visitslogging.JobQueueVisitLog;
import org.javades.jqueues.r5.entity.jq.queue.SimQueueSimpleEventType;
import org.javades.jqueues.r5.entity.jq.queue.serverless.ALIMIT;
import org.javades.jqueues.r5.extensions.ratelimit.RateLimitSimpleEventType;
import org.javades.jqueues.r5.extensions.ratelimit.SimQueueRateLimitStateHandler;
import org.javades.jqueues.r5.util.predictor.AbstractSimQueuePredictor;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionAmbiguityException;
import org.javades.jqueues.r5.util.predictor.SimQueuePredictionException;
import org.javades.jqueues.r5.util.predictor.state.DefaultSimQueueState;
import org.javades.jqueues.r5.util.predictor.state.SimQueueState;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadScheduleException;
import org.javades.jqueues.r5.util.predictor.workload.WorkloadSchedule_SQ_SV_ROEL_U;

public class SimQueuePredictor_ALIMIT
extends AbstractSimQueuePredictor<ALIMIT> {
    @Override
    public SimQueueState<SimJob, ALIMIT> createQueueState(ALIMIT queue, boolean isROEL) {
        DefaultSimQueueState queueState = (DefaultSimQueueState)super.createQueueState(queue, isROEL);
        SimQueueRateLimitStateHandler queueStateHandler = new SimQueueRateLimitStateHandler();
        queueState.registerHandler(queueStateHandler);
        queueStateHandler.setRateLimited(queue.getRateLimit() == 0.0);
        return queueState;
    }

    public String toString() {
        return "Predictor[ALIMIT[?]]";
    }

    @Override
    public boolean isStartArmed(ALIMIT queue, SimQueueState<SimJob, ALIMIT> queueState) {
        return false;
    }

    @Override
    public double getNextQueueEventTimeBeyond(ALIMIT queue, SimQueueState<SimJob, ALIMIT> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes) {
        if (queue == null || queueState == null || queueEventTypes == null) {
            throw new IllegalArgumentException();
        }
        queueEventTypes.clear();
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        if (!queueStateHandler.isRateLimited()) {
            return Double.NaN;
        }
        queueEventTypes.add(RateLimitSimpleEventType.RATE_LIMIT_EXPIRATION);
        return queueStateHandler.getLastArrTime() + 1.0 / queue.getRateLimit();
    }

    @Override
    public void doWorkloadEvents_SQ_SV_ROEL_U(ALIMIT queue, WorkloadSchedule_SQ_SV_ROEL_U workloadSchedule, SimQueueState<SimJob, ALIMIT> queueState, Set<SimEntitySimpleEventType.Member> workloadEventTypes, Set<JobQueueVisitLog<SimJob, ALIMIT>> visitLogsSet) throws SimQueuePredictionException, WorkloadScheduleException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || workloadSchedule == null || queueState == null || workloadEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (workloadEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        SimEntitySimpleEventType.Member member = eventType = workloadEventTypes.isEmpty() ? null : workloadEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == SimQueueSimpleEventType.QUEUE_ACCESS_VACATION) {
                boolean queueAccessVacation = (Boolean)workloadSchedule.getQueueAccessVacationMap_SQ_SV_ROEL_U().get(time);
                queueState.setQueueAccessVacation(time, queueAccessVacation);
            } else if (eventType == SimQueueSimpleEventType.ARRIVAL) {
                SimJob job = (SimJob)workloadSchedule.getJobArrivalsMap_SQ_SV_ROEL_U().get(time);
                HashSet<SimJob> arrivals = new HashSet<SimJob>();
                arrivals.add(job);
                if (queueState.isQueueAccessVacation() || queueStateHandler.isRateLimited()) {
                    queueState.doExits(time, arrivals, null, null, null, visitLogsSet);
                } else {
                    queueState.doExits(time, null, null, arrivals, null, visitLogsSet);
                    queueStateHandler.setLastArrTime(time);
                    if (Double.isFinite(queue.getRateLimit())) {
                        queueStateHandler.setRateLimited(true);
                    }
                }
            } else if (eventType == SimQueueSimpleEventType.REVOCATION) {
                SimJob job = (SimJob)((Map)workloadSchedule.getJobRevocationsMap_SQ_SV_ROEL_U().get(time)).entrySet().iterator().next().getKey();
                if (queueState.getJobs().contains(job)) {
                    HashSet<SimJob> revocations = new HashSet<SimJob>();
                    revocations.add(job);
                    queueState.doExits(time, null, revocations, null, null, visitLogsSet);
                }
            } else if (eventType == SimQueueSimpleEventType.SERVER_ACCESS_CREDITS) {
                int newSac = (Integer)workloadSchedule.getServerAccessCreditsMap_SQ_SV_ROEL_U().get(time);
                queueState.setServerAccessCredits(time, newSac);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            workloadEventTypes.remove(eventType);
        }
    }

    @Override
    public void doQueueEvents_SQ_SV_ROEL_U(ALIMIT queue, SimQueueState<SimJob, ALIMIT> queueState, Set<SimEntitySimpleEventType.Member> queueEventTypes, Set<JobQueueVisitLog<SimJob, ALIMIT>> visitLogsSet) throws SimQueuePredictionException {
        SimEntitySimpleEventType.Member eventType;
        if (queue == null || queueState == null || queueEventTypes == null || visitLogsSet == null) {
            throw new IllegalArgumentException();
        }
        if (queueEventTypes.size() > 1) {
            throw new SimQueuePredictionAmbiguityException();
        }
        double time = queueState.getTime();
        if (Double.isNaN(time)) {
            throw new IllegalStateException();
        }
        SimQueueRateLimitStateHandler queueStateHandler = (SimQueueRateLimitStateHandler)((DefaultSimQueueState)queueState).getHandler("SimQueueRateLimitStateHandler");
        SimEntitySimpleEventType.Member member = eventType = queueEventTypes.isEmpty() ? null : queueEventTypes.iterator().next();
        if (eventType != null) {
            if (eventType == RateLimitSimpleEventType.RATE_LIMIT_EXPIRATION) {
                queueStateHandler.setRateLimited(false);
            } else {
                throw new RuntimeException();
            }
        }
        if (eventType != null) {
            queueEventTypes.remove(eventType);
        }
    }

    @Override
    public void updateToTime(ALIMIT queue, SimQueueState queueState, double newTime) {
        if (queue == null || queueState == null) {
            throw new IllegalArgumentException();
        }
        if (Double.isNaN(newTime)) {
            throw new IllegalArgumentException();
        }
        queueState.setTime(newTime);
    }
}

